// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of information about a domain.
 */
public class DomainSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the domain.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The timestamp showing when the domain is created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The client-provided description of the domain.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The service-generated identifier for the domain.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * The current status of the domain.
     */
    public val domainStatus: aws.sdk.kotlin.services.voiceid.model.DomainStatus? = builder.domainStatus
    /**
     * The client-provided name for the domain.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to encrypt your data.
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * Details about the most recent server-side encryption configuration update. When the server-side encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this update is complete, the domain's data can only be accessed using the new KMS key.
     */
    public val serverSideEncryptionUpdateDetails: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails? = builder.serverSideEncryptionUpdateDetails
    /**
     * The timestamp showing the domain's last update.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.DomainSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("description=*** Sensitive Data Redacted ***,")
        append("domainId=$domainId,")
        append("domainStatus=$domainStatus,")
        append("name=*** Sensitive Data Redacted ***,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("serverSideEncryptionUpdateDetails=$serverSideEncryptionUpdateDetails,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (domainStatus?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionUpdateDetails?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (domainId != other.domainId) return false
        if (domainStatus != other.domainStatus) return false
        if (name != other.name) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (serverSideEncryptionUpdateDetails != other.serverSideEncryptionUpdateDetails) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.DomainSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the domain.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp showing when the domain is created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The client-provided description of the domain.
         */
        public var description: kotlin.String? = null
        /**
         * The service-generated identifier for the domain.
         */
        public var domainId: kotlin.String? = null
        /**
         * The current status of the domain.
         */
        public var domainStatus: aws.sdk.kotlin.services.voiceid.model.DomainStatus? = null
        /**
         * The client-provided name for the domain.
         */
        public var name: kotlin.String? = null
        /**
         * The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to encrypt your data.
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionConfiguration? = null
        /**
         * Details about the most recent server-side encryption configuration update. When the server-side encryption configuration is changed, dependency on the old KMS key is removed through an asynchronous process. When this update is complete, the domain's data can only be accessed using the new KMS key.
         */
        public var serverSideEncryptionUpdateDetails: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails? = null
        /**
         * The timestamp showing the domain's last update.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.DomainSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.description = x.description
            this.domainId = x.domainId
            this.domainStatus = x.domainStatus
            this.name = x.name
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.serverSideEncryptionUpdateDetails = x.serverSideEncryptionUpdateDetails
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.DomainSummary = DomainSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails] inside the given [block]
         */
        public fun serverSideEncryptionUpdateDetails(block: aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionUpdateDetails = aws.sdk.kotlin.services.voiceid.model.ServerSideEncryptionUpdateDetails.invoke(block)
        }
    }
}
