// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request failed due to a conflict. Check the `ConflictType` and error message for more details.
 */
public class ConflictException private constructor(builder: Builder) : VoiceIdException() {

    /**
     * The type of conflict which caused a ConflictException. Possible types and the corresponding error messages are as follows:
     * + `DOMAIN_NOT_ACTIVE`: The domain is not active.
     * + `CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT`: You cannot change the speaker ID after an enrollment has been requested.
     * + `ENROLLMENT_ALREADY_EXISTS`: There is already an enrollment for this session.
     * + `SPEAKER_NOT_SET`: You must set the speaker ID before requesting an enrollment.
     * + `SPEAKER_OPTED_OUT`: You cannot request an enrollment for an opted out speaker.
     * + `CONCURRENT_CHANGES`: The request could not be processed as the resource was modified by another request during execution.
     */
    public val conflictType: aws.sdk.kotlin.services.voiceid.model.ConflictType? = builder.conflictType
    override val message: kotlin.String? = builder.message

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.ConflictException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictException(")
        append("conflictType=$conflictType,")
        append("message=$message)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conflictType?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConflictException

        if (conflictType != other.conflictType) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.ConflictException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of conflict which caused a ConflictException. Possible types and the corresponding error messages are as follows:
         * + `DOMAIN_NOT_ACTIVE`: The domain is not active.
         * + `CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT`: You cannot change the speaker ID after an enrollment has been requested.
         * + `ENROLLMENT_ALREADY_EXISTS`: There is already an enrollment for this session.
         * + `SPEAKER_NOT_SET`: You must set the speaker ID before requesting an enrollment.
         * + `SPEAKER_OPTED_OUT`: You cannot request an enrollment for an opted out speaker.
         * + `CONCURRENT_CHANGES`: The request could not be processed as the resource was modified by another request during execution.
         */
        public var conflictType: aws.sdk.kotlin.services.voiceid.model.ConflictType? = null
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.ConflictException) : this() {
            this.conflictType = x.conflictType
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.ConflictException = ConflictException(this)
    }
}
