// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The authentication result produced by Voice ID, processed against the current session state and streamed audio of the speaker.
 */
public class AuthenticationResult private constructor(builder: Builder) {
    /**
     * A timestamp indicating when audio aggregation ended for this authentication result.
     */
    public val audioAggregationEndedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.audioAggregationEndedAt
    /**
     * A timestamp indicating when audio aggregation started for this authentication result.
     */
    public val audioAggregationStartedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.audioAggregationStartedAt
    /**
     * The unique identifier for this authentication result. Because there can be multiple authentications for a given session, this field helps to identify if the returned result is from a previous streaming activity or a new result. Note that in absence of any new streaming activity, `AcceptanceThreshold` changes, or `SpeakerId` changes, Voice ID always returns cached Authentication Result for this API.
     */
    public val authenticationResultId: kotlin.String? = builder.authenticationResultId
    /**
     * The `AuthenticationConfiguration` used to generate this authentication result.
     */
    public val configuration: aws.sdk.kotlin.services.voiceid.model.AuthenticationConfiguration? = builder.configuration
    /**
     * The client-provided identifier for the speaker whose authentication result is produced. Only present if a `SpeakerId` is provided for the session.
     */
    public val customerSpeakerId: kotlin.String? = builder.customerSpeakerId
    /**
     * The authentication decision produced by Voice ID, processed against the current session state and streamed audio of the speaker.
     */
    public val decision: aws.sdk.kotlin.services.voiceid.model.AuthenticationDecision? = builder.decision
    /**
     * The service-generated identifier for the speaker whose authentication result is produced.
     */
    public val generatedSpeakerId: kotlin.String? = builder.generatedSpeakerId
    /**
     * The authentication score for the speaker whose authentication result is produced. This value is only present if the authentication decision is either `ACCEPT` or `REJECT`.
     */
    public val score: kotlin.Int? = builder.score

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.voiceid.model.AuthenticationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthenticationResult(")
        append("audioAggregationEndedAt=$audioAggregationEndedAt,")
        append("audioAggregationStartedAt=$audioAggregationStartedAt,")
        append("authenticationResultId=$authenticationResultId,")
        append("configuration=$configuration,")
        append("customerSpeakerId=*** Sensitive Data Redacted ***,")
        append("decision=$decision,")
        append("generatedSpeakerId=$generatedSpeakerId,")
        append("score=$score)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audioAggregationEndedAt?.hashCode() ?: 0
        result = 31 * result + (audioAggregationStartedAt?.hashCode() ?: 0)
        result = 31 * result + (authenticationResultId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (customerSpeakerId?.hashCode() ?: 0)
        result = 31 * result + (decision?.hashCode() ?: 0)
        result = 31 * result + (generatedSpeakerId?.hashCode() ?: 0)
        result = 31 * result + (score ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthenticationResult

        if (audioAggregationEndedAt != other.audioAggregationEndedAt) return false
        if (audioAggregationStartedAt != other.audioAggregationStartedAt) return false
        if (authenticationResultId != other.authenticationResultId) return false
        if (configuration != other.configuration) return false
        if (customerSpeakerId != other.customerSpeakerId) return false
        if (decision != other.decision) return false
        if (generatedSpeakerId != other.generatedSpeakerId) return false
        if (score != other.score) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.voiceid.model.AuthenticationResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp indicating when audio aggregation ended for this authentication result.
         */
        public var audioAggregationEndedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp indicating when audio aggregation started for this authentication result.
         */
        public var audioAggregationStartedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for this authentication result. Because there can be multiple authentications for a given session, this field helps to identify if the returned result is from a previous streaming activity or a new result. Note that in absence of any new streaming activity, `AcceptanceThreshold` changes, or `SpeakerId` changes, Voice ID always returns cached Authentication Result for this API.
         */
        public var authenticationResultId: kotlin.String? = null
        /**
         * The `AuthenticationConfiguration` used to generate this authentication result.
         */
        public var configuration: aws.sdk.kotlin.services.voiceid.model.AuthenticationConfiguration? = null
        /**
         * The client-provided identifier for the speaker whose authentication result is produced. Only present if a `SpeakerId` is provided for the session.
         */
        public var customerSpeakerId: kotlin.String? = null
        /**
         * The authentication decision produced by Voice ID, processed against the current session state and streamed audio of the speaker.
         */
        public var decision: aws.sdk.kotlin.services.voiceid.model.AuthenticationDecision? = null
        /**
         * The service-generated identifier for the speaker whose authentication result is produced.
         */
        public var generatedSpeakerId: kotlin.String? = null
        /**
         * The authentication score for the speaker whose authentication result is produced. This value is only present if the authentication decision is either `ACCEPT` or `REJECT`.
         */
        public var score: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.voiceid.model.AuthenticationResult) : this() {
            this.audioAggregationEndedAt = x.audioAggregationEndedAt
            this.audioAggregationStartedAt = x.audioAggregationStartedAt
            this.authenticationResultId = x.authenticationResultId
            this.configuration = x.configuration
            this.customerSpeakerId = x.customerSpeakerId
            this.decision = x.decision
            this.generatedSpeakerId = x.generatedSpeakerId
            this.score = x.score
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.voiceid.model.AuthenticationResult = AuthenticationResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.voiceid.model.AuthenticationConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.voiceid.model.AuthenticationConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.voiceid.model.AuthenticationConfiguration.invoke(block)
        }
    }
}
