// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.voiceid

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.voiceid.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.voiceid.model.*
import aws.sdk.kotlin.services.voiceid.model.CreateDomainRequest
import aws.sdk.kotlin.services.voiceid.model.CreateDomainResponse
import aws.sdk.kotlin.services.voiceid.model.DeleteDomainRequest
import aws.sdk.kotlin.services.voiceid.model.DeleteDomainResponse
import aws.sdk.kotlin.services.voiceid.model.DeleteFraudsterRequest
import aws.sdk.kotlin.services.voiceid.model.DeleteFraudsterResponse
import aws.sdk.kotlin.services.voiceid.model.DeleteSpeakerRequest
import aws.sdk.kotlin.services.voiceid.model.DeleteSpeakerResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeDomainRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeDomainResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterRegistrationJobRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterRegistrationJobResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeFraudsterResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerEnrollmentJobRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerEnrollmentJobResponse
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerRequest
import aws.sdk.kotlin.services.voiceid.model.DescribeSpeakerResponse
import aws.sdk.kotlin.services.voiceid.model.EvaluateSessionRequest
import aws.sdk.kotlin.services.voiceid.model.EvaluateSessionResponse
import aws.sdk.kotlin.services.voiceid.model.ListDomainsRequest
import aws.sdk.kotlin.services.voiceid.model.ListDomainsResponse
import aws.sdk.kotlin.services.voiceid.model.ListFraudsterRegistrationJobsRequest
import aws.sdk.kotlin.services.voiceid.model.ListFraudsterRegistrationJobsResponse
import aws.sdk.kotlin.services.voiceid.model.ListSpeakerEnrollmentJobsRequest
import aws.sdk.kotlin.services.voiceid.model.ListSpeakerEnrollmentJobsResponse
import aws.sdk.kotlin.services.voiceid.model.ListSpeakersRequest
import aws.sdk.kotlin.services.voiceid.model.ListSpeakersResponse
import aws.sdk.kotlin.services.voiceid.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.voiceid.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.voiceid.model.OptOutSpeakerRequest
import aws.sdk.kotlin.services.voiceid.model.OptOutSpeakerResponse
import aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobRequest
import aws.sdk.kotlin.services.voiceid.model.StartFraudsterRegistrationJobResponse
import aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobRequest
import aws.sdk.kotlin.services.voiceid.model.StartSpeakerEnrollmentJobResponse
import aws.sdk.kotlin.services.voiceid.model.TagResourceRequest
import aws.sdk.kotlin.services.voiceid.model.TagResourceResponse
import aws.sdk.kotlin.services.voiceid.model.UntagResourceRequest
import aws.sdk.kotlin.services.voiceid.model.UntagResourceResponse
import aws.sdk.kotlin.services.voiceid.model.UpdateDomainRequest
import aws.sdk.kotlin.services.voiceid.model.UpdateDomainResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Connect Voice ID provides real-time caller authentication and fraud screening. This guide describes the APIs used for this service.
 */
public interface VoiceIdClient : SdkClient {

    override val serviceName: String
        get() = "Voice ID"
    /**
     * VoiceIdClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): VoiceIdClient {
            val config = Config.Builder().apply(block).build()
            return DefaultVoiceIdClient(config)
        }

        public operator fun invoke(config: Config): VoiceIdClient = DefaultVoiceIdClient(config)

        /**
         * Construct a [VoiceIdClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): VoiceIdClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultVoiceIdClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints.
     */
    public suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Deletes the specified domain from Voice ID.
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes the specified fraudster from Voice ID.
     */
    public suspend fun deleteFraudster(input: DeleteFraudsterRequest): DeleteFraudsterResponse

    /**
     * Deletes the specified speaker from Voice ID.
     */
    public suspend fun deleteSpeaker(input: DeleteSpeakerRequest): DeleteSpeakerResponse

    /**
     * Describes the specified domain.
     */
    public suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Describes the specified fraudster.
     */
    public suspend fun describeFraudster(input: DescribeFraudsterRequest): DescribeFraudsterResponse

    /**
     * Describes the specified fraudster registration job.
     */
    public suspend fun describeFraudsterRegistrationJob(input: DescribeFraudsterRegistrationJobRequest): DescribeFraudsterRegistrationJobResponse

    /**
     * Describes the specified speaker.
     */
    public suspend fun describeSpeaker(input: DescribeSpeakerRequest): DescribeSpeakerResponse

    /**
     * Describes the specified speaker enrollment job.
     */
    public suspend fun describeSpeakerEnrollmentJob(input: DescribeSpeakerEnrollmentJobRequest): DescribeSpeakerEnrollmentJobResponse

    /**
     * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
     */
    public suspend fun evaluateSession(input: EvaluateSessionRequest): EvaluateSessionResponse

    /**
     * Lists all the domains in the Amazon Web Services account.
     */
    public suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest {}): ListDomainsResponse

    /**
     * Lists all the fraudster registration jobs in the domain with the given `JobStatus`. If `JobStatus` is not provided, this lists all fraudster registration jobs in the given domain.
     */
    public suspend fun listFraudsterRegistrationJobs(input: ListFraudsterRegistrationJobsRequest): ListFraudsterRegistrationJobsResponse

    /**
     * Lists all the speaker enrollment jobs in the domain with the specified `JobStatus`. If `JobStatus` is not provided, this lists all jobs with all possible speaker enrollment job statuses.
     */
    public suspend fun listSpeakerEnrollmentJobs(input: ListSpeakerEnrollmentJobsRequest): ListSpeakerEnrollmentJobsResponse

    /**
     * Lists all speakers in a specified domain.
     */
    public suspend fun listSpeakers(input: ListSpeakersRequest): ListSpeakersResponse

    /**
     * Lists all tags associated with a specified Voice ID resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
     */
    public suspend fun optOutSpeaker(input: OptOutSpeakerRequest): OptOutSpeakerResponse

    /**
     * Starts a new batch fraudster registration job using provided details.
     */
    public suspend fun startFraudsterRegistrationJob(input: StartFraudsterRegistrationJobRequest): StartFraudsterRegistrationJobResponse

    /**
     * Starts a new batch speaker enrollment job using specified details.
     */
    public suspend fun startSpeakerEnrollmentJob(input: StartSpeakerEnrollmentJobRequest): StartSpeakerEnrollmentJobResponse

    /**
     * Tags a Voice ID resource with the provided list of tags.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes specified tags from a specified Amazon Connect Voice ID resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.
     */
    public suspend fun updateDomain(input: UpdateDomainRequest): UpdateDomainResponse
}

/**
 * Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints.
 */
public suspend inline fun VoiceIdClient.createDomain(crossinline block: CreateDomainRequest.Builder.() -> Unit): CreateDomainResponse = createDomain(CreateDomainRequest.Builder().apply(block).build())

/**
 * Deletes the specified domain from Voice ID.
 */
public suspend inline fun VoiceIdClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * Deletes the specified fraudster from Voice ID.
 */
public suspend inline fun VoiceIdClient.deleteFraudster(crossinline block: DeleteFraudsterRequest.Builder.() -> Unit): DeleteFraudsterResponse = deleteFraudster(DeleteFraudsterRequest.Builder().apply(block).build())

/**
 * Deletes the specified speaker from Voice ID.
 */
public suspend inline fun VoiceIdClient.deleteSpeaker(crossinline block: DeleteSpeakerRequest.Builder.() -> Unit): DeleteSpeakerResponse = deleteSpeaker(DeleteSpeakerRequest.Builder().apply(block).build())

/**
 * Describes the specified domain.
 */
public suspend inline fun VoiceIdClient.describeDomain(crossinline block: DescribeDomainRequest.Builder.() -> Unit): DescribeDomainResponse = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

/**
 * Describes the specified fraudster.
 */
public suspend inline fun VoiceIdClient.describeFraudster(crossinline block: DescribeFraudsterRequest.Builder.() -> Unit): DescribeFraudsterResponse = describeFraudster(DescribeFraudsterRequest.Builder().apply(block).build())

/**
 * Describes the specified fraudster registration job.
 */
public suspend inline fun VoiceIdClient.describeFraudsterRegistrationJob(crossinline block: DescribeFraudsterRegistrationJobRequest.Builder.() -> Unit): DescribeFraudsterRegistrationJobResponse = describeFraudsterRegistrationJob(DescribeFraudsterRegistrationJobRequest.Builder().apply(block).build())

/**
 * Describes the specified speaker.
 */
public suspend inline fun VoiceIdClient.describeSpeaker(crossinline block: DescribeSpeakerRequest.Builder.() -> Unit): DescribeSpeakerResponse = describeSpeaker(DescribeSpeakerRequest.Builder().apply(block).build())

/**
 * Describes the specified speaker enrollment job.
 */
public suspend inline fun VoiceIdClient.describeSpeakerEnrollmentJob(crossinline block: DescribeSpeakerEnrollmentJobRequest.Builder.() -> Unit): DescribeSpeakerEnrollmentJobResponse = describeSpeakerEnrollmentJob(DescribeSpeakerEnrollmentJobRequest.Builder().apply(block).build())

/**
 * Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
 */
public suspend inline fun VoiceIdClient.evaluateSession(crossinline block: EvaluateSessionRequest.Builder.() -> Unit): EvaluateSessionResponse = evaluateSession(EvaluateSessionRequest.Builder().apply(block).build())

/**
 * Lists all the domains in the Amazon Web Services account.
 */
public suspend inline fun VoiceIdClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Lists all the fraudster registration jobs in the domain with the given `JobStatus`. If `JobStatus` is not provided, this lists all fraudster registration jobs in the given domain.
 */
public suspend inline fun VoiceIdClient.listFraudsterRegistrationJobs(crossinline block: ListFraudsterRegistrationJobsRequest.Builder.() -> Unit): ListFraudsterRegistrationJobsResponse = listFraudsterRegistrationJobs(ListFraudsterRegistrationJobsRequest.Builder().apply(block).build())

/**
 * Lists all the speaker enrollment jobs in the domain with the specified `JobStatus`. If `JobStatus` is not provided, this lists all jobs with all possible speaker enrollment job statuses.
 */
public suspend inline fun VoiceIdClient.listSpeakerEnrollmentJobs(crossinline block: ListSpeakerEnrollmentJobsRequest.Builder.() -> Unit): ListSpeakerEnrollmentJobsResponse = listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsRequest.Builder().apply(block).build())

/**
 * Lists all speakers in a specified domain.
 */
public suspend inline fun VoiceIdClient.listSpeakers(crossinline block: ListSpeakersRequest.Builder.() -> Unit): ListSpeakersResponse = listSpeakers(ListSpeakersRequest.Builder().apply(block).build())

/**
 * Lists all tags associated with a specified Voice ID resource.
 */
public suspend inline fun VoiceIdClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
 */
public suspend inline fun VoiceIdClient.optOutSpeaker(crossinline block: OptOutSpeakerRequest.Builder.() -> Unit): OptOutSpeakerResponse = optOutSpeaker(OptOutSpeakerRequest.Builder().apply(block).build())

/**
 * Starts a new batch fraudster registration job using provided details.
 */
public suspend inline fun VoiceIdClient.startFraudsterRegistrationJob(crossinline block: StartFraudsterRegistrationJobRequest.Builder.() -> Unit): StartFraudsterRegistrationJobResponse = startFraudsterRegistrationJob(StartFraudsterRegistrationJobRequest.Builder().apply(block).build())

/**
 * Starts a new batch speaker enrollment job using specified details.
 */
public suspend inline fun VoiceIdClient.startSpeakerEnrollmentJob(crossinline block: StartSpeakerEnrollmentJobRequest.Builder.() -> Unit): StartSpeakerEnrollmentJobResponse = startSpeakerEnrollmentJob(StartSpeakerEnrollmentJobRequest.Builder().apply(block).build())

/**
 * Tags a Voice ID resource with the provided list of tags.
 */
public suspend inline fun VoiceIdClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes specified tags from a specified Amazon Connect Voice ID resource.
 */
public suspend inline fun VoiceIdClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.
 */
public suspend inline fun VoiceIdClient.updateDomain(crossinline block: UpdateDomainRequest.Builder.() -> Unit): UpdateDomainResponse = updateDomain(UpdateDomainRequest.Builder().apply(block).build())
