// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of an OpenID Connect (OIDC) identity source for handling identity (ID) token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the `aud` claim, or audiences, that you want to accept.
 *
 * This data type is part of a [OpenIdConnectTokenSelectionItem](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectTokenSelectionItem.html) structure, which is a parameter of [ListIdentitySources](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
 */
public class OpenIdConnectIdentityTokenConfigurationItem private constructor(builder: Builder) {
    /**
     * The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider. For example, `1example23456789, 2example10111213`.
     */
    public val clientIds: List<String>? = builder.clientIds
    /**
     * The claim that determines the principal in OIDC access tokens. For example, `sub`.
     */
    public val principalIdClaim: kotlin.String = builder.principalIdClaim

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectIdentityTokenConfigurationItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenIdConnectIdentityTokenConfigurationItem(")
        append("clientIds=*** Sensitive Data Redacted ***,")
        append("principalIdClaim=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIds?.hashCode() ?: 0
        result = 31 * result + (principalIdClaim.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenIdConnectIdentityTokenConfigurationItem

        if (clientIds != other.clientIds) return false
        if (principalIdClaim != other.principalIdClaim) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectIdentityTokenConfigurationItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID token audience, or client ID, claim values that you want to accept in your policy store from an OIDC identity provider. For example, `1example23456789, 2example10111213`.
         */
        public var clientIds: List<String>? = null
        /**
         * The claim that determines the principal in OIDC access tokens. For example, `sub`.
         */
        public var principalIdClaim: kotlin.String = "sub"

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectIdentityTokenConfigurationItem) : this() {
            this.clientIds = x.clientIds
            this.principalIdClaim = x.principalIdClaim
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectIdentityTokenConfigurationItem = OpenIdConnectIdentityTokenConfigurationItem(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
