// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetPolicyStoreResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the policy store.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time that the policy store was originally created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * Descriptive text that you can provide to help with identification of the current policy store.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date and time that the policy store was last updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedDate) { "A non-null value must be provided for lastUpdatedDate" }
    /**
     * The ID of the policy store;
     */
    public val policyStoreId: kotlin.String = requireNotNull(builder.policyStoreId) { "A non-null value must be provided for policyStoreId" }
    /**
     * The current validation settings for the policy store.
     */
    public val validationSettings: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings? = builder.validationSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyStoreResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPolicyStoreResponse(")
        append("arn=$arn,")
        append("createdDate=$createdDate,")
        append("description=*** Sensitive Data Redacted ***,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("policyStoreId=$policyStoreId,")
        append("validationSettings=$validationSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdDate.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate.hashCode())
        result = 31 * result + (policyStoreId.hashCode())
        result = 31 * result + (validationSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPolicyStoreResponse

        if (arn != other.arn) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (policyStoreId != other.policyStoreId) return false
        if (validationSettings != other.validationSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyStoreResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the policy store.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the policy store was originally created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Descriptive text that you can provide to help with identification of the current policy store.
         */
        public var description: kotlin.String? = null
        /**
         * The date and time that the policy store was last updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the policy store;
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * The current validation settings for the policy store.
         */
        public var validationSettings: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyStoreResponse) : this() {
            this.arn = x.arn
            this.createdDate = x.createdDate
            this.description = x.description
            this.lastUpdatedDate = x.lastUpdatedDate
            this.policyStoreId = x.policyStoreId
            this.validationSettings = x.validationSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyStoreResponse = GetPolicyStoreResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings] inside the given [block]
         */
        public fun validationSettings(block: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings.Builder.() -> kotlin.Unit) {
            this.validationSettings = aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (lastUpdatedDate == null) lastUpdatedDate = Instant.fromEpochSeconds(0)
            if (policyStoreId == null) policyStoreId = ""
            return this
        }
    }
}
