// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a policy returned from a `BatchGetPolicy` API request.
 */
public class BatchGetPolicyOutputItem private constructor(builder: Builder) {
    /**
     * The date and time the policy was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * The policy definition of an item in the list of policies returned.
     */
    public val definition: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinitionDetail? = builder.definition
    /**
     * The date and time the policy was most recently updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedDate) { "A non-null value must be provided for lastUpdatedDate" }
    /**
     * The identifier of the policy you want information about.
     */
    public val policyId: kotlin.String = requireNotNull(builder.policyId) { "A non-null value must be provided for policyId" }
    /**
     * The identifier of the policy store where the policy you want information about is stored.
     */
    public val policyStoreId: kotlin.String = requireNotNull(builder.policyStoreId) { "A non-null value must be provided for policyStoreId" }
    /**
     * The type of the policy. This is one of the following values:
     * + `STATIC`
     * + `TEMPLATE_LINKED`
     */
    public val policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType = requireNotNull(builder.policyType) { "A non-null value must be provided for policyType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.BatchGetPolicyOutputItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetPolicyOutputItem(")
        append("createdDate=$createdDate,")
        append("definition=$definition,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("policyId=$policyId,")
        append("policyStoreId=$policyStoreId,")
        append("policyType=$policyType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate.hashCode()
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate.hashCode())
        result = 31 * result + (policyId.hashCode())
        result = 31 * result + (policyStoreId.hashCode())
        result = 31 * result + (policyType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetPolicyOutputItem

        if (createdDate != other.createdDate) return false
        if (definition != other.definition) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (policyId != other.policyId) return false
        if (policyStoreId != other.policyStoreId) return false
        if (policyType != other.policyType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.BatchGetPolicyOutputItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the policy was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The policy definition of an item in the list of policies returned.
         */
        public var definition: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinitionDetail? = null
        /**
         * The date and time the policy was most recently updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the policy you want information about.
         */
        public var policyId: kotlin.String? = null
        /**
         * The identifier of the policy store where the policy you want information about is stored.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * The type of the policy. This is one of the following values:
         * + `STATIC`
         * + `TEMPLATE_LINKED`
         */
        public var policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.BatchGetPolicyOutputItem) : this() {
            this.createdDate = x.createdDate
            this.definition = x.definition
            this.lastUpdatedDate = x.lastUpdatedDate
            this.policyId = x.policyId
            this.policyStoreId = x.policyStoreId
            this.policyType = x.policyType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.BatchGetPolicyOutputItem = BatchGetPolicyOutputItem(this)

        internal fun correctErrors(): Builder {
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (lastUpdatedDate == null) lastUpdatedDate = Instant.fromEpochSeconds(0)
            if (policyId == null) policyId = ""
            if (policyStoreId == null) policyStoreId = ""
            if (policyType == null) policyType = PolicyType.SdkUnknown("no value provided")
            return this
        }
    }
}
