// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request failed because one or more input parameters don't satisfy their constraint requirements. The output is provided as a list of fields and a reason for each field that isn't valid.
 *
 * The possible reasons include the following:
 * + **UnrecognizedEntityType**The policy includes an entity type that isn't found in the schema.
 * + **UnrecognizedActionId**The policy includes an action id that isn't found in the schema.
 * + **InvalidActionApplication**The policy includes an action that, according to the schema, doesn't support the specified principal and resource.
 * + **UnexpectedType**The policy included an operand that isn't a valid type for the specified operation.
 * + **IncompatibleTypes**The types of elements included in a `set`, or the types of expressions used in an `if...then...else` clause aren't compatible in this context.
 * + **MissingAttribute**The policy attempts to access a record or entity attribute that isn't specified in the schema. Test for the existence of the attribute first before attempting to access its value. For more information, see the [has (presence of attribute test) operator](https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test) in the *Cedar Policy Language Guide*.
 * + **UnsafeOptionalAttributeAccess**The policy attempts to access a record or entity attribute that is optional and isn't guaranteed to be present. Test for the existence of the attribute first before attempting to access its value. For more information, see the [has (presence of attribute test) operator](https://docs.cedarpolicy.com/policies/syntax-operators.html#has-presence-of-attribute-test) in the *Cedar Policy Language Guide*.
 * + **ImpossiblePolicy**Cedar has determined that a policy condition always evaluates to false. If the policy is always false, it can never apply to any query, and so it can never affect an authorization decision.
 * + **WrongNumberArguments**The policy references an extension type with the wrong number of arguments.
 * + **FunctionArgumentValidationError**Cedar couldn't parse the argument passed to an extension type. For example, a string that is to be parsed as an IPv4 address can contain only digits and the period character.
 */
public class ValidationException private constructor(builder: Builder) : VerifiedPermissionsException(builder.message) {

    /**
     * The list of fields that aren't valid.
     */
    public val fieldList: List<ValidationExceptionField>? = builder.fieldList

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.ValidationException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidationException(")
        append("fieldList=$fieldList,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldList?.hashCode() ?: 0
        result = 31 * result + (message.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidationException

        if (fieldList != other.fieldList) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.ValidationException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of fields that aren't valid.
         */
        public var fieldList: List<ValidationExceptionField>? = null
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationException) : this() {
            this.fieldList = x.fieldList
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.ValidationException = ValidationException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            return this
        }
    }
}
