// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIdentitySourceRequest private constructor(builder: Builder) {
    /**
     * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value.](https://wikipedia.org/wiki/Universally_unique_identifier).
     *
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     *
     * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `ConflictException` error.
     *
     * Verified Permissions recognizes a `ClientToken` for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of `ClientToken`.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Specifies the details required to communicate with the identity provider (IdP) associated with this identity source.
     */
    public val configuration: aws.sdk.kotlin.services.verifiedpermissions.model.Configuration? = builder.configuration
    /**
     * Specifies the ID of the policy store in which you want to store this identity source. Only policies and requests made using this policy store can reference identities from the identity provider configured in the new identity source.
     */
    public val policyStoreId: kotlin.String? = builder.policyStoreId
    /**
     * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
     */
    public val principalEntityType: kotlin.String? = builder.principalEntityType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.CreateIdentitySourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIdentitySourceRequest(")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("policyStoreId=$policyStoreId,")
        append("principalEntityType=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (policyStoreId?.hashCode() ?: 0)
        result = 31 * result + (principalEntityType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIdentitySourceRequest

        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (policyStoreId != other.policyStoreId) return false
        if (principalEntityType != other.principalEntityType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.CreateIdentitySourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value.](https://wikipedia.org/wiki/Universally_unique_identifier).
         *
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         *
         * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `ConflictException` error.
         *
         * Verified Permissions recognizes a `ClientToken` for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of `ClientToken`.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Specifies the details required to communicate with the identity provider (IdP) associated with this identity source.
         */
        public var configuration: aws.sdk.kotlin.services.verifiedpermissions.model.Configuration? = null
        /**
         * Specifies the ID of the policy store in which you want to store this identity source. Only policies and requests made using this policy store can reference identities from the identity provider configured in the new identity source.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * Specifies the namespace and data type of the principals generated for identities authenticated by the new identity source.
         */
        public var principalEntityType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.CreateIdentitySourceRequest) : this() {
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.policyStoreId = x.policyStoreId
            this.principalEntityType = x.principalEntityType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.CreateIdentitySourceRequest = CreateIdentitySourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
