// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * Contains additional details about the context of the request. Verified Permissions evaluates this information in an authorization request as part of the `when` and `unless` clauses in a policy.
 *
 * This data type is used as a request parameter for the [IsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html), [BatchIsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html), and [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html) operations.
 *
 * If you're passing context as part of the request, exactly one instance of `context` must be passed. If you don't want to pass context, omit the `context` parameter from your request rather than sending `context {}`.
 *
 * Example: `"context":{"contextMap":{"&lt;KeyName1&gt;":{"boolean":true},"&lt;KeyName2&gt;":{"long":1234}}}`
 */
public sealed class ContextDefinition {
    /**
     * A Cedar JSON string representation of the context needed to successfully evaluate an authorization request.
     *
     * Example: `{"cedarJson":"{\"&lt;KeyName1&gt;\": true, \"&lt;KeyName2&gt;\": 1234}" }`
     */
    public data class CedarJson(val value: kotlin.String) : aws.sdk.kotlin.services.verifiedpermissions.model.ContextDefinition() {
    }

    /**
     * An list of attributes that are needed to successfully evaluate an authorization request. Each attribute in this array must include a map of a data type and its value.
     *
     * Example: `"contextMap":{"&lt;KeyName1&gt;":{"boolean":true},"&lt;KeyName2&gt;":{"long":1234}}`
     */
    public data class ContextMap(val value: Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>) : aws.sdk.kotlin.services.verifiedpermissions.model.ContextDefinition() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.verifiedpermissions.model.ContextDefinition() {
    }

    /**
     * Casts this [ContextDefinition] as a [CedarJson] and retrieves its [kotlin.String] value. Throws an exception if the [ContextDefinition] is not a
     * [CedarJson].
     */
    public fun asCedarJson(): kotlin.String = (this as ContextDefinition.CedarJson).value

    /**
     * Casts this [ContextDefinition] as a [CedarJson] and retrieves its [kotlin.String] value. Returns null if the [ContextDefinition] is not a [CedarJson].
     */
    public fun asCedarJsonOrNull(): kotlin.String? = (this as? ContextDefinition.CedarJson)?.value

    /**
     * Casts this [ContextDefinition] as a [ContextMap] and retrieves its [Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>] value. Throws an exception if the [ContextDefinition] is not a
     * [ContextMap].
     */
    public fun asContextMap(): Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue> = (this as ContextDefinition.ContextMap).value

    /**
     * Casts this [ContextDefinition] as a [ContextMap] and retrieves its [Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>] value. Returns null if the [ContextDefinition] is not a [ContextMap].
     */
    public fun asContextMapOrNull(): Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>? = (this as? ContextDefinition.ContextMap)?.value
}
