// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdatePolicyResponse private constructor(builder: Builder) {
    /**
     * The action that a policy permits or forbids. For example, `{"actions": [{"actionId": "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto", "entityType": "PhotoFlash::Action"}]}`.
     */
    public val actions: List<ActionIdentifier>? = builder.actions
    /**
     * The date and time that the policy was originally created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * The effect of the decision that a policy returns to an authorization request. For example, `"effect": "Permit"`.
     */
    public val effect: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyEffect? = builder.effect
    /**
     * The date and time that the policy was most recently updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedDate) { "A non-null value must be provided for lastUpdatedDate" }
    /**
     * The ID of the policy that was updated.
     */
    public val policyId: kotlin.String = requireNotNull(builder.policyId) { "A non-null value must be provided for policyId" }
    /**
     * The ID of the policy store that contains the policy that was updated.
     */
    public val policyStoreId: kotlin.String = requireNotNull(builder.policyStoreId) { "A non-null value must be provided for policyStoreId" }
    /**
     * The type of the policy that was updated.
     */
    public val policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType = requireNotNull(builder.policyType) { "A non-null value must be provided for policyType" }
    /**
     * The principal specified in the policy's scope. This element isn't included in the response when `Principal` isn't present in the policy content.
     */
    public val principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.principal
    /**
     * The resource specified in the policy's scope. This element isn't included in the response when `Resource` isn't present in the policy content.
     */
    public val resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePolicyResponse(")
        append("actions=$actions,")
        append("createdDate=$createdDate,")
        append("effect=$effect,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("policyId=$policyId,")
        append("policyStoreId=$policyStoreId,")
        append("policyType=$policyType,")
        append("principal=$principal,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (createdDate.hashCode())
        result = 31 * result + (effect?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate.hashCode())
        result = 31 * result + (policyId.hashCode())
        result = 31 * result + (policyStoreId.hashCode())
        result = 31 * result + (policyType.hashCode())
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePolicyResponse

        if (actions != other.actions) return false
        if (createdDate != other.createdDate) return false
        if (effect != other.effect) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (policyId != other.policyId) return false
        if (policyStoreId != other.policyStoreId) return false
        if (policyType != other.policyType) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action that a policy permits or forbids. For example, `{"actions": [{"actionId": "ViewPhoto", "actionType": "PhotoFlash::Action"}, {"entityID": "SharePhoto", "entityType": "PhotoFlash::Action"}]}`.
         */
        public var actions: List<ActionIdentifier>? = null
        /**
         * The date and time that the policy was originally created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The effect of the decision that a policy returns to an authorization request. For example, `"effect": "Permit"`.
         */
        public var effect: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyEffect? = null
        /**
         * The date and time that the policy was most recently updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the policy that was updated.
         */
        public var policyId: kotlin.String? = null
        /**
         * The ID of the policy store that contains the policy that was updated.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * The type of the policy that was updated.
         */
        public var policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType? = null
        /**
         * The principal specified in the policy's scope. This element isn't included in the response when `Principal` isn't present in the policy content.
         */
        public var principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null
        /**
         * The resource specified in the policy's scope. This element isn't included in the response when `Resource` isn't present in the policy content.
         */
        public var resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyResponse) : this() {
            this.actions = x.actions
            this.createdDate = x.createdDate
            this.effect = x.effect
            this.lastUpdatedDate = x.lastUpdatedDate
            this.policyId = x.policyId
            this.policyStoreId = x.policyStoreId
            this.policyType = x.policyType
            this.principal = x.principal
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyResponse = UpdatePolicyResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun principal(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.principal = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (lastUpdatedDate == null) lastUpdatedDate = Instant.fromEpochSeconds(0)
            if (policyId == null) policyId = ""
            if (policyStoreId == null) policyStoreId = ""
            if (policyType == null) policyType = PolicyType.SdkUnknown("no value provided")
            return this
        }
    }
}
