// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a policy store.
 *
 * This data type is used as a response parameter for the [ListPolicyStores](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyStores.html) operation.
 */
public class PolicyStoreItem private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the policy store.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The date and time the policy was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * Descriptive text that you can provide to help with identification of the current policy store.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date and time the policy store was most recently updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * The unique identifier of the policy store.
     */
    public val policyStoreId: kotlin.String = requireNotNull(builder.policyStoreId) { "A non-null value must be provided for policyStoreId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyStoreItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyStoreItem(")
        append("arn=$arn,")
        append("createdDate=$createdDate,")
        append("description=*** Sensitive Data Redacted ***,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("policyStoreId=$policyStoreId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdDate.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (policyStoreId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyStoreItem

        if (arn != other.arn) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (policyStoreId != other.policyStoreId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyStoreItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the policy store.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time the policy was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Descriptive text that you can provide to help with identification of the current policy store.
         */
        public var description: kotlin.String? = null
        /**
         * The date and time the policy store was most recently updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the policy store.
         */
        public var policyStoreId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyStoreItem) : this() {
            this.arn = x.arn
            this.createdDate = x.createdDate
            this.description = x.description
            this.lastUpdatedDate = x.lastUpdatedDate
            this.policyStoreId = x.policyStoreId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyStoreItem = PolicyStoreItem(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (policyStoreId == null) policyStoreId = ""
            return this
        }
    }
}
