// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains configuration details of a Amazon Cognito user pool for use with an identity source.
 */
public class UpdateCognitoUserPoolConfiguration private constructor(builder: Builder) {
    /**
     * The client ID of an app client that is configured for the specified Amazon Cognito user pool.
     */
    public val clientIds: List<String>? = builder.clientIds
    /**
     * The configuration of the user groups from an Amazon Cognito user pool identity source.
     */
    public val groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoGroupConfiguration? = builder.groupConfiguration
    /**
     * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon Cognito user pool associated with this identity source.
     */
    public val userPoolArn: kotlin.String = requireNotNull(builder.userPoolArn) { "A non-null value must be provided for userPoolArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoUserPoolConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCognitoUserPoolConfiguration(")
        append("clientIds=*** Sensitive Data Redacted ***,")
        append("groupConfiguration=$groupConfiguration,")
        append("userPoolArn=$userPoolArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIds?.hashCode() ?: 0
        result = 31 * result + (groupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userPoolArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateCognitoUserPoolConfiguration

        if (clientIds != other.clientIds) return false
        if (groupConfiguration != other.groupConfiguration) return false
        if (userPoolArn != other.userPoolArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoUserPoolConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The client ID of an app client that is configured for the specified Amazon Cognito user pool.
         */
        public var clientIds: List<String>? = null
        /**
         * The configuration of the user groups from an Amazon Cognito user pool identity source.
         */
        public var groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoGroupConfiguration? = null
        /**
         * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon Cognito user pool associated with this identity source.
         */
        public var userPoolArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoUserPoolConfiguration) : this() {
            this.clientIds = x.clientIds
            this.groupConfiguration = x.groupConfiguration
            this.userPoolArn = x.userPoolArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoUserPoolConfiguration = UpdateCognitoUserPoolConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoGroupConfiguration] inside the given [block]
         */
        public fun groupConfiguration(block: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.groupConfiguration = aws.sdk.kotlin.services.verifiedpermissions.model.UpdateCognitoGroupConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (userPoolArn == null) userPoolArn = ""
            return this
        }
    }
}
