// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration of an OpenID Connect (OIDC) identity source for handling access token claims. Contains the claim that you want to identify as the principal in an authorization request, and the values of the `aud` claim, or audiences, that you want to accept.
 *
 * This data type is part of a [UpdateOpenIdConnectTokenSelection](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateOpenIdConnectTokenSelection.html) structure, which is a parameter to [UpdateIdentitySource](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdateIdentitySource.html).
 */
public class UpdateOpenIdConnectAccessTokenConfiguration private constructor(builder: Builder) {
    /**
     * The access token `aud` claim values that you want to accept in your policy store. For example, `https://myapp.example.com, https://myapp2.example.com`.
     */
    public val audiences: List<String>? = builder.audiences
    /**
     * The claim that determines the principal in OIDC access tokens. For example, `sub`.
     */
    public val principalIdClaim: kotlin.String = builder.principalIdClaim

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateOpenIdConnectAccessTokenConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateOpenIdConnectAccessTokenConfiguration(")
        append("audiences=$audiences,")
        append("principalIdClaim=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = audiences?.hashCode() ?: 0
        result = 31 * result + (principalIdClaim.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateOpenIdConnectAccessTokenConfiguration

        if (audiences != other.audiences) return false
        if (principalIdClaim != other.principalIdClaim) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateOpenIdConnectAccessTokenConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The access token `aud` claim values that you want to accept in your policy store. For example, `https://myapp.example.com, https://myapp2.example.com`.
         */
        public var audiences: List<String>? = null
        /**
         * The claim that determines the principal in OIDC access tokens. For example, `sub`.
         */
        public var principalIdClaim: kotlin.String = "sub"

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateOpenIdConnectAccessTokenConfiguration) : this() {
            this.audiences = x.audiences
            this.principalIdClaim = x.principalIdClaim
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateOpenIdConnectAccessTokenConfiguration = UpdateOpenIdConnectAccessTokenConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
