// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about an entity that can be referenced in a Cedar policy.
 *
 * This data type is used as one of the fields in the [EntitiesDefinition](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntitiesDefinition.html) structure.
 *
 * `{ "identifier": { "entityType": "Photo", "entityId": "VacationPhoto94.jpg" }, "attributes": {}, "parents": [ { "entityType": "Album", "entityId": "alice_folder" } ] }`
 */
public class EntityItem private constructor(builder: Builder) {
    /**
     * A list of attributes for the entity.
     */
    public val attributes: Map<String, AttributeValue>? = builder.attributes
    /**
     * The identifier of the entity.
     */
    public val identifier: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.identifier
    /**
     * The parent entities in the hierarchy that contains the entity. A principal or resource entity can be defined with at most 99 *transitive parents* per authorization request.
     *
     * A transitive parent is an entity in the hierarchy of entities including all direct parents, and parents of parents. For example, a user can be a member of 91 groups if one of those groups is a member of eight groups, for a total of 100: one entity, 91 entity parents, and eight parents of parents.
     */
    public val parents: List<EntityIdentifier>? = builder.parents

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.EntityItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityItem(")
        append("attributes=$attributes,")
        append("identifier=$identifier,")
        append("parents=$parents")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (parents?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityItem

        if (attributes != other.attributes) return false
        if (identifier != other.identifier) return false
        if (parents != other.parents) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.EntityItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of attributes for the entity.
         */
        public var attributes: Map<String, AttributeValue>? = null
        /**
         * The identifier of the entity.
         */
        public var identifier: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null
        /**
         * The parent entities in the hierarchy that contains the entity. A principal or resource entity can be defined with at most 99 *transitive parents* per authorization request.
         *
         * A transitive parent is an entity in the hierarchy of entities including all direct parents, and parents of parents. For example, a user can be a member of 91 groups if one of those groups is a member of eight groups, for a total of 100: one entity, 91 entity parents, and eight parents of parents.
         */
        public var parents: List<EntityIdentifier>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.EntityItem) : this() {
            this.attributes = x.attributes
            this.identifier = x.identifier
            this.parents = x.parents
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.EntityItem = EntityItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun identifier(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.identifier = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
