// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * Contains configuration information used when creating a new identity source.
 *
 * This data type is used as a request parameter for the [CreateIdentitySource](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html) operation.
 */
public sealed class Configuration {
    /**
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. It specifies the [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a Amazon Cognito user pool and one or more application client IDs.
     *
     * Example: `"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}}`
     */
    public data class CognitoUserPoolConfiguration(val value: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration) : aws.sdk.kotlin.services.verifiedpermissions.model.Configuration() {
    }

    /**
     * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.
     *
     * Example:`"configuration":{"openIdConnectConfiguration":{"issuer":"https://auth.example.com","tokenSelection":{"accessTokenOnly":{"audiences":["https://myapp.example.com","https://myapp2.example.com"],"principalIdClaim":"sub"}},"entityIdPrefix":"MyOIDCProvider","groupConfiguration":{"groupClaim":"groups","groupEntityType":"MyCorp::UserGroup"}}}`
     */
    public data class OpenIdConnectConfiguration(val value: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfiguration) : aws.sdk.kotlin.services.verifiedpermissions.model.Configuration() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.verifiedpermissions.model.Configuration() {
    }

    /**
     * Casts this [Configuration] as a [CognitoUserPoolConfiguration] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration] value. Throws an exception if the [Configuration] is not a
     * [CognitoUserPoolConfiguration].
     */
    public fun asCognitoUserPoolConfiguration(): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration = (this as Configuration.CognitoUserPoolConfiguration).value

    /**
     * Casts this [Configuration] as a [CognitoUserPoolConfiguration] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration] value. Returns null if the [Configuration] is not a [CognitoUserPoolConfiguration].
     */
    public fun asCognitoUserPoolConfigurationOrNull(): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration? = (this as? Configuration.CognitoUserPoolConfiguration)?.value

    /**
     * Casts this [Configuration] as a [OpenIdConnectConfiguration] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfiguration] value. Throws an exception if the [Configuration] is not a
     * [OpenIdConnectConfiguration].
     */
    public fun asOpenIdConnectConfiguration(): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfiguration = (this as Configuration.OpenIdConnectConfiguration).value

    /**
     * Casts this [Configuration] as a [OpenIdConnectConfiguration] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfiguration] value. Returns null if the [Configuration] is not a [OpenIdConnectConfiguration].
     */
    public fun asOpenIdConnectConfigurationOrNull(): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfiguration? = (this as? Configuration.OpenIdConnectConfiguration)?.value
}
