// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.serde

import aws.sdk.kotlin.services.verifiedpermissions.model.ConfigurationDetail
import aws.sdk.kotlin.services.verifiedpermissions.model.GetIdentitySourceResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.IdentitySourceDetails
import aws.sdk.kotlin.services.verifiedpermissions.model.VerifiedPermissionsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetIdentitySourceOperationDeserializer: HttpDeserializer.NonStreaming<GetIdentitySourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetIdentitySourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetIdentitySourceError(context, call, payload)
        }
        val builder = GetIdentitySourceResponse.Builder()

        if (payload != null) {
            deserializeGetIdentitySourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetIdentitySourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VerifiedPermissionsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> VerifiedPermissionsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIdentitySourceOperationBody(builder: GetIdentitySourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("details"))
    val IDENTITYSOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identitySourceId"))
    val LASTUPDATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDate"))
    val POLICYSTOREID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyStoreId"))
    val PRINCIPALENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("principalEntityType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATION_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DETAILS_DESCRIPTOR)
        field(IDENTITYSOURCEID_DESCRIPTOR)
        field(LASTUPDATEDDATE_DESCRIPTOR)
        field(POLICYSTOREID_DESCRIPTOR)
        field(PRINCIPALENTITYTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATION_DESCRIPTOR.index -> builder.configuration = deserializeConfigurationDetailDocument(deserializer)
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromIso8601(it) }
                DETAILS_DESCRIPTOR.index -> builder.details = deserializeIdentitySourceDetailsDocument(deserializer)
                IDENTITYSOURCEID_DESCRIPTOR.index -> builder.identitySourceId = deserializeString()
                LASTUPDATEDDATE_DESCRIPTOR.index -> builder.lastUpdatedDate = deserializeString().let { Instant.fromIso8601(it) }
                POLICYSTOREID_DESCRIPTOR.index -> builder.policyStoreId = deserializeString()
                PRINCIPALENTITYTYPE_DESCRIPTOR.index -> builder.principalEntityType = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
