// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.serde

import aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier
import aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier
import aws.sdk.kotlin.services.verifiedpermissions.model.PolicyEffect
import aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType
import aws.sdk.kotlin.services.verifiedpermissions.model.VerifiedPermissionsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class CreatePolicyOperationDeserializer: HttpDeserializer.NonStreaming<CreatePolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreatePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreatePolicyError(context, call, payload)
        }
        val builder = CreatePolicyResponse.Builder()

        if (payload != null) {
            deserializeCreatePolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreatePolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VerifiedPermissionsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> VerifiedPermissionsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePolicyOperationBody(builder: CreatePolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("actions"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val EFFECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("effect"))
    val LASTUPDATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDate"))
    val POLICYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyId"))
    val POLICYSTOREID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyStoreId"))
    val POLICYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("policyType"))
    val PRINCIPAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("principal"))
    val RESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(EFFECT_DESCRIPTOR)
        field(LASTUPDATEDDATE_DESCRIPTOR)
        field(POLICYID_DESCRIPTOR)
        field(POLICYSTOREID_DESCRIPTOR)
        field(POLICYTYPE_DESCRIPTOR)
        field(PRINCIPAL_DESCRIPTOR)
        field(RESOURCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIONS_DESCRIPTOR.index -> builder.actions =
                    deserializer.deserializeList(ACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ActionIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeActionIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromIso8601(it) }
                EFFECT_DESCRIPTOR.index -> builder.effect = deserializeString().let { PolicyEffect.fromValue(it) }
                LASTUPDATEDDATE_DESCRIPTOR.index -> builder.lastUpdatedDate = deserializeString().let { Instant.fromIso8601(it) }
                POLICYID_DESCRIPTOR.index -> builder.policyId = deserializeString()
                POLICYSTOREID_DESCRIPTOR.index -> builder.policyStoreId = deserializeString()
                POLICYTYPE_DESCRIPTOR.index -> builder.policyType = deserializeString().let { PolicyType.fromValue(it) }
                PRINCIPAL_DESCRIPTOR.index -> builder.principal = deserializeEntityIdentifierDocument(deserializer)
                RESOURCE_DESCRIPTOR.index -> builder.resource = deserializeEntityIdentifierDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
