// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.paginators

import aws.sdk.kotlin.services.verifiedpermissions.VerifiedPermissionsClient
import aws.sdk.kotlin.services.verifiedpermissions.model.IdentitySourceItem
import aws.sdk.kotlin.services.verifiedpermissions.model.ListIdentitySourcesRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListIdentitySourcesResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyStoresRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyStoresResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyTemplatesRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyTemplatesResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.PolicyItem
import aws.sdk.kotlin.services.verifiedpermissions.model.PolicyStoreItem
import aws.sdk.kotlin.services.verifiedpermissions.model.PolicyTemplateItem
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListIdentitySourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIdentitySourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentitySourcesResponse]
 */
public fun VerifiedPermissionsClient.listIdentitySourcesPaginated(initialRequest: ListIdentitySourcesRequest): Flow<ListIdentitySourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIdentitySourcesPaginated.listIdentitySources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIdentitySourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIdentitySourcesResponse]
 */
public fun VerifiedPermissionsClient.listIdentitySourcesPaginated(block: ListIdentitySourcesRequest.Builder.() -> Unit): Flow<ListIdentitySourcesResponse> =
    listIdentitySourcesPaginated(ListIdentitySourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIdentitySourcesPaginated]
 * to access the nested member [IdentitySourceItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IdentitySourceItem]
 */
@JvmName("listIdentitySourcesResponseIdentitySourceItem")
public fun Flow<ListIdentitySourcesResponse>.identitySources(): Flow<IdentitySourceItem> =
    transform() { response ->
        response.identitySources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
public fun VerifiedPermissionsClient.listPoliciesPaginated(initialRequest: ListPoliciesRequest): Flow<ListPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPoliciesPaginated.listPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
public fun VerifiedPermissionsClient.listPoliciesPaginated(block: ListPoliciesRequest.Builder.() -> Unit): Flow<ListPoliciesResponse> =
    listPoliciesPaginated(ListPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPoliciesPaginated]
 * to access the nested member [PolicyItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyItem]
 */
@JvmName("listPoliciesResponsePolicyItem")
public fun Flow<ListPoliciesResponse>.policies(): Flow<PolicyItem> =
    transform() { response ->
        response.policies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPolicyStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPolicyStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyStoresResponse]
 */
public fun VerifiedPermissionsClient.listPolicyStoresPaginated(initialRequest: ListPolicyStoresRequest = ListPolicyStoresRequest { }): Flow<ListPolicyStoresResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPolicyStoresPaginated.listPolicyStores(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPolicyStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyStoresResponse]
 */
public fun VerifiedPermissionsClient.listPolicyStoresPaginated(block: ListPolicyStoresRequest.Builder.() -> Unit): Flow<ListPolicyStoresResponse> =
    listPolicyStoresPaginated(ListPolicyStoresRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPolicyStoresPaginated]
 * to access the nested member [PolicyStoreItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyStoreItem]
 */
@JvmName("listPolicyStoresResponsePolicyStoreItem")
public fun Flow<ListPolicyStoresResponse>.policyStores(): Flow<PolicyStoreItem> =
    transform() { response ->
        response.policyStores?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPolicyTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPolicyTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyTemplatesResponse]
 */
public fun VerifiedPermissionsClient.listPolicyTemplatesPaginated(initialRequest: ListPolicyTemplatesRequest): Flow<ListPolicyTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPolicyTemplatesPaginated.listPolicyTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPolicyTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPolicyTemplatesResponse]
 */
public fun VerifiedPermissionsClient.listPolicyTemplatesPaginated(block: ListPolicyTemplatesRequest.Builder.() -> Unit): Flow<ListPolicyTemplatesResponse> =
    listPolicyTemplatesPaginated(ListPolicyTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPolicyTemplatesPaginated]
 * to access the nested member [PolicyTemplateItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyTemplateItem]
 */
@JvmName("listPolicyTemplatesResponsePolicyTemplateItem")
public fun Flow<ListPolicyTemplatesResponse>.policyTemplates(): Flow<PolicyTemplateItem> =
    transform() { response ->
        response.policyTemplates?.forEach {
            emit(it)
        }
    }
