// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you want to map it to. For example, this object can map the contents of a `groups` claim to `MyCorp::UserGroup`.
 *
 * This data type is part of a [OpenIdConnectConfiguration](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_OpenIdConnectConfiguration.html) structure, which is a parameter of [CreateIdentitySource](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
 */
public class OpenIdConnectGroupConfiguration private constructor(builder: Builder) {
    /**
     * The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
     */
    public val groupClaim: kotlin.String = requireNotNull(builder.groupClaim) { "A non-null value must be provided for groupClaim" }
    /**
     * The policy store entity type that you want to map your users' group claim to. For example, `MyCorp::UserGroup`. A group entity type is an entity that can have a user entity type as a member.
     */
    public val groupEntityType: kotlin.String = requireNotNull(builder.groupEntityType) { "A non-null value must be provided for groupEntityType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenIdConnectGroupConfiguration(")
        append("groupClaim=*** Sensitive Data Redacted ***,")
        append("groupEntityType=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupClaim.hashCode()
        result = 31 * result + (groupEntityType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenIdConnectGroupConfiguration

        if (groupClaim != other.groupClaim) return false
        if (groupEntityType != other.groupEntityType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The token claim that you want Verified Permissions to interpret as group membership. For example, `groups`.
         */
        public var groupClaim: kotlin.String? = null
        /**
         * The policy store entity type that you want to map your users' group claim to. For example, `MyCorp::UserGroup`. A group entity type is an entity that can have a user entity type as a member.
         */
        public var groupEntityType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfiguration) : this() {
            this.groupClaim = x.groupClaim
            this.groupEntityType = x.groupEntityType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfiguration = OpenIdConnectGroupConfiguration(this)

        internal fun correctErrors(): Builder {
            if (groupClaim == null) groupClaim = ""
            if (groupEntityType == null) groupEntityType = ""
            return this
        }
    }
}
