// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains configuration details of an OpenID Connect (OIDC) identity provider, or identity source, that Verified Permissions can use to generate entities from authenticated identities. It specifies the issuer URL, token type that you want to use, and policy store entity details.
 *
 * This data type is part of a [ConfigurationItem](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationDetail.html) structure, which is a parameter to [ListIdentitySources](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
 */
public class OpenIdConnectConfigurationItem private constructor(builder: Builder) {
    /**
     * A descriptive string that you want to prefix to user entities from your OIDC identity provider. For example, if you set an `entityIdPrefix` of `MyOIDCProvider`, you can reference principals in your policies in the format `MyCorp::User::MyOIDCProvider|Carlos`.
     */
    public val entityIdPrefix: kotlin.String? = builder.entityIdPrefix
    /**
     * The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you want to map it to. For example, this object can map the contents of a `groups` claim to `MyCorp::UserGroup`.
     */
    public val groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfigurationItem? = builder.groupConfiguration
    /**
     * The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
     */
    public val issuer: kotlin.String = requireNotNull(builder.issuer) { "A non-null value must be provided for issuer" }
    /**
     * The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.
     */
    public val tokenSelection: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectTokenSelectionItem? = builder.tokenSelection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfigurationItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpenIdConnectConfigurationItem(")
        append("entityIdPrefix=*** Sensitive Data Redacted ***,")
        append("groupConfiguration=$groupConfiguration,")
        append("issuer=$issuer,")
        append("tokenSelection=$tokenSelection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityIdPrefix?.hashCode() ?: 0
        result = 31 * result + (groupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (issuer.hashCode())
        result = 31 * result + (tokenSelection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpenIdConnectConfigurationItem

        if (entityIdPrefix != other.entityIdPrefix) return false
        if (groupConfiguration != other.groupConfiguration) return false
        if (issuer != other.issuer) return false
        if (tokenSelection != other.tokenSelection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfigurationItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A descriptive string that you want to prefix to user entities from your OIDC identity provider. For example, if you set an `entityIdPrefix` of `MyOIDCProvider`, you can reference principals in your policies in the format `MyCorp::User::MyOIDCProvider|Carlos`.
         */
        public var entityIdPrefix: kotlin.String? = null
        /**
         * The claim in OIDC identity provider tokens that indicates a user's group membership, and the entity type that you want to map it to. For example, this object can map the contents of a `groups` claim to `MyCorp::UserGroup`.
         */
        public var groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfigurationItem? = null
        /**
         * The issuer URL of an OIDC identity provider. This URL must have an OIDC discovery endpoint at the path `.well-known/openid-configuration`.
         */
        public var issuer: kotlin.String? = null
        /**
         * The token type that you want to process from your OIDC identity provider. Your policy store can process either identity (ID) or access tokens from a given OIDC identity source.
         */
        public var tokenSelection: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectTokenSelectionItem? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfigurationItem) : this() {
            this.entityIdPrefix = x.entityIdPrefix
            this.groupConfiguration = x.groupConfiguration
            this.issuer = x.issuer
            this.tokenSelection = x.tokenSelection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectConfigurationItem = OpenIdConnectConfigurationItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfigurationItem] inside the given [block]
         */
        public fun groupConfiguration(block: aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfigurationItem.Builder.() -> kotlin.Unit) {
            this.groupConfiguration = aws.sdk.kotlin.services.verifiedpermissions.model.OpenIdConnectGroupConfigurationItem.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (issuer == null) issuer = ""
            return this
        }
    }
}
