// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions.
 *
 * This data type part of a [Configuration](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_Configuration.html) structure that is used as a parameter to [CreateIdentitySource](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
 *
 * Example:`"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"],"groupConfiguration": {"groupEntityType": "MyCorp::Group"}}`
 */
public class CognitoUserPoolConfiguration private constructor(builder: Builder) {
    /**
     * The unique application client IDs that are associated with the specified Amazon Cognito user pool.
     *
     * Example: `"ClientIds": ["&amp;ExampleCogClientId;"]`
     */
    public val clientIds: List<String>? = builder.clientIds
    /**
     * The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.
     */
    public val groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration? = builder.groupConfiguration
    /**
     * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon Cognito user pool that contains the identities to be authorized.
     *
     * Example: `"UserPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"`
     */
    public val userPoolArn: kotlin.String = requireNotNull(builder.userPoolArn) { "A non-null value must be provided for userPoolArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoUserPoolConfiguration(")
        append("clientIds=$clientIds,")
        append("groupConfiguration=$groupConfiguration,")
        append("userPoolArn=$userPoolArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIds?.hashCode() ?: 0
        result = 31 * result + (groupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userPoolArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoUserPoolConfiguration

        if (clientIds != other.clientIds) return false
        if (groupConfiguration != other.groupConfiguration) return false
        if (userPoolArn != other.userPoolArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique application client IDs that are associated with the specified Amazon Cognito user pool.
         *
         * Example: `"ClientIds": ["&amp;ExampleCogClientId;"]`
         */
        public var clientIds: List<String>? = null
        /**
         * The type of entity that a policy store maps to groups from an Amazon Cognito user pool identity source.
         */
        public var groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration? = null
        /**
         * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon Cognito user pool that contains the identities to be authorized.
         *
         * Example: `"UserPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"`
         */
        public var userPoolArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration) : this() {
            this.clientIds = x.clientIds
            this.groupConfiguration = x.groupConfiguration
            this.userPoolArn = x.userPoolArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration = CognitoUserPoolConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration] inside the given [block]
         */
        public fun groupConfiguration(block: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration.Builder.() -> kotlin.Unit) {
            this.groupConfiguration = aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (userPoolArn == null) userPoolArn = ""
            return this
        }
    }
}
