// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.verifiedpermissions.auth.DefaultVerifiedPermissionsAuthSchemeProvider
import aws.sdk.kotlin.services.verifiedpermissions.auth.VerifiedPermissionsAuthSchemeProvider
import aws.sdk.kotlin.services.verifiedpermissions.endpoints.DefaultVerifiedPermissionsEndpointProvider
import aws.sdk.kotlin.services.verifiedpermissions.endpoints.VerifiedPermissionsEndpointParameters
import aws.sdk.kotlin.services.verifiedpermissions.endpoints.VerifiedPermissionsEndpointProvider
import aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.CreateIdentitySourceRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.CreateIdentitySourceResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyStoreRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyStoreResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyTemplateRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyTemplateResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.DeleteIdentitySourceRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.DeleteIdentitySourceResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.DeletePolicyRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.DeletePolicyResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.DeletePolicyStoreRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.DeletePolicyStoreResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.DeletePolicyTemplateRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.DeletePolicyTemplateResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.GetIdentitySourceRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.GetIdentitySourceResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyStoreRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyStoreResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyTemplateRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyTemplateResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.GetSchemaRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.GetSchemaResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedWithTokenRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedWithTokenResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.ListIdentitySourcesRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListIdentitySourcesResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyStoresRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyStoresResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyTemplatesRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.ListPolicyTemplatesResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.PutSchemaRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.PutSchemaResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdateIdentitySourceRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdateIdentitySourceResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyStoreRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyStoreResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyTemplateRequest
import aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyTemplateResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "VerifiedPermissions"
public const val SdkVersion: String = "1.2.35"
public const val ServiceApiVersion: String = "2021-12-01"

/**
 * Amazon Verified Permissions is a permissions management service from Amazon Web Services. You can use Verified Permissions to manage permissions for your application, and authorize user access based on those permissions. Using Verified Permissions, application developers can grant access based on information about the users, resources, and requested actions. You can also evaluate additional information like group membership, attributes of the resources, and session context, such as time of request and IP addresses. Verified Permissions manages these permissions by letting you create and store authorization policies for your applications, such as consumer-facing web sites and enterprise business systems.
 *
 * Verified Permissions uses Cedar as the policy language to express your permission requirements. Cedar supports both role-based access control (RBAC) and attribute-based access control (ABAC) authorization models.
 *
 * For more information about configuring, administering, and using Amazon Verified Permissions in your applications, see the [Amazon Verified Permissions User Guide](https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/).
 *
 * For more information about the Cedar policy language, see the [Cedar Policy Language Guide](https://docs.cedarpolicy.com/).
 *
 * When you write Cedar policies that reference principals, resources and actions, you can define the unique identifiers used for each of those elements. We strongly recommend that you follow these best practices:
 * + **Use values like universally unique identifiers (UUIDs) for all principal and resource identifiers.**For example, if user `jane` leaves the company, and you later let someone else use the name `jane`, then that new user automatically gets access to everything granted by policies that still reference `User::"jane"`. Cedar can’t distinguish between the new user and the old. This applies to both principal and resource identifiers. Always use identifiers that are guaranteed unique and never reused to ensure that you don’t unintentionally grant access because of the presence of an old identifier in a policy.Where you use a UUID for an entity, we recommend that you follow it with the // comment specifier and the ‘friendly’ name of your entity. This helps to make your policies easier to understand. For example: principal == User::"a1b2c3d4-e5f6-a1b2-c3d4-EXAMPLE11111", // alice
 * + **Do not include personally identifying, confidential, or sensitive information as part of the unique identifier for your principals or resources.** These identifiers are included in log entries shared in CloudTrail trails.
 * Several operations return structures that appear similar, but have different purposes. As new functionality is added to the product, the structure used in a parameter of one operation might need to change in a way that wouldn't make sense for the same parameter in a different operation. To help you understand the purpose of each, the following naming convention is used for the structures:
 * + Parameter type structures that end in `Detail` are used in `Get` operations.
 * + Parameter type structures that end in `Item` are used in `List` operations.
 * + Parameter type structures that use neither suffix are used in the mutating (create and update) operations.
 */
public interface VerifiedPermissionsClient : SdkClient {
    /**
     * VerifiedPermissionsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, VerifiedPermissionsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "VerifiedPermissions",
                "VERIFIEDPERMISSIONS",
                "verifiedpermissions",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, VerifiedPermissionsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): VerifiedPermissionsClient = DefaultVerifiedPermissionsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: VerifiedPermissionsEndpointProvider = builder.endpointProvider ?: DefaultVerifiedPermissionsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: VerifiedPermissionsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultVerifiedPermissionsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "VerifiedPermissions"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: VerifiedPermissionsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: VerifiedPermissionsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Makes a series of decisions about multiple authorization requests for one principal or resource. Each request contains the equivalent content of an `IsAuthorized` request: principal, action, resource, and context. Either the `principal` or the `resource` parameter must be identical across all requests. For example, Verified Permissions won't evaluate a pair of requests where `bob` views `photo1` and `alice` views `photo2`. Authorization of `bob` to view `photo1` and `photo2`, or `bob` and `alice` to view `photo1`, are valid batches.
     *
     * The request is evaluated against all policies in the specified policy store that match the entities that you declare. The result of the decisions is a series of `Allow` or `Deny` responses, along with the IDs of the policies that produced each decision.
     *
     * The `entities` of a `BatchIsAuthorized` API request can contain up to 100 principals and up to 100 resources. The `requests` of a `BatchIsAuthorized` API request can contain up to 30 requests.
     *
     * The `BatchIsAuthorized` operation doesn't have its own IAM permission. To authorize this operation for Amazon Web Services principals, include the permission `verifiedpermissions:IsAuthorized` in their IAM policies.
     */
    public suspend fun batchIsAuthorized(input: BatchIsAuthorizedRequest): BatchIsAuthorizedResponse

    /**
     * Makes a series of decisions about multiple authorization requests for one token. The principal in this request comes from an external identity source in the form of an identity or access token, formatted as a [JSON web token (JWT)](https://wikipedia.org/wiki/JSON_Web_Token). The information in the parameters can also define additional context that Verified Permissions can include in the evaluations.
     *
     * The request is evaluated against all policies in the specified policy store that match the entities that you provide in the entities declaration and in the token. The result of the decisions is a series of `Allow` or `Deny` responses, along with the IDs of the policies that produced each decision.
     *
     * The `entities` of a `BatchIsAuthorizedWithToken` API request can contain up to 100 resources and up to 99 user groups. The `requests` of a `BatchIsAuthorizedWithToken` API request can contain up to 30 requests.
     *
     * The `BatchIsAuthorizedWithToken` operation doesn't have its own IAM permission. To authorize this operation for Amazon Web Services principals, include the permission `verifiedpermissions:IsAuthorizedWithToken` in their IAM policies.
     */
    public suspend fun batchIsAuthorizedWithToken(input: BatchIsAuthorizedWithTokenRequest): BatchIsAuthorizedWithTokenResponse

    /**
     * Adds an identity source to a policy store–an Amazon Cognito user pool or OpenID Connect (OIDC) identity provider (IdP).
     *
     * After you create an identity source, you can use the identities provided by the IdP as proxies for the principal in authorization queries that use the [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html) or [BatchIsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorizedWithToken.html) API operations. These identities take the form of tokens that contain claims about the user, such as IDs, attributes and group memberships. Identity sources provide identity (ID) tokens and access tokens. Verified Permissions derives information about your user and session from token claims. Access tokens provide action `context` to your policies, and ID tokens provide principal `Attributes`.
     *
     * Tokens from an identity source user continue to be usable until they expire. Token revocation and resource deletion have no effect on the validity of a token in your policy store
     *
     * To reference a user from this identity source in your Cedar policies, refer to the following syntax examples.
     * + Amazon Cognito user pool: `Namespace::[Entity type]::[User pool ID]|[user principal attribute]`, for example `MyCorp::User::us-east-1_EXAMPLE|a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`.
     * + OpenID Connect (OIDC) provider: `Namespace::[Entity type]::[principalIdClaim]|[user principal attribute]`, for example `MyCorp::User::MyOIDCProvider|a1b2c3d4-5678-90ab-cdef-EXAMPLE22222`.
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun createIdentitySource(input: CreateIdentitySourceRequest): CreateIdentitySourceResponse

    /**
     * Creates a Cedar policy and saves it in the specified policy store. You can create either a static policy or a policy linked to a policy template.
     * + To create a static policy, provide the Cedar policy text in the `StaticPolicy` section of the `PolicyDefinition`.
     * + To create a policy that is dynamically linked to a policy template, specify the policy template ID and the principal and resource to associate with this policy in the `templateLinked` section of the `PolicyDefinition`. If the policy template is ever updated, any policies linked to the policy template automatically use the updated template.
     *
     * Creating a policy causes it to be validated against the schema in the policy store. If the policy doesn't pass validation, the operation fails and the policy isn't stored.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun createPolicy(input: CreatePolicyRequest): CreatePolicyResponse

    /**
     * Creates a policy store. A policy store is a container for policy resources.
     *
     * Although [Cedar supports multiple namespaces](https://docs.cedarpolicy.com/schema/schema.html#namespace), Verified Permissions currently supports only one namespace per policy store.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun createPolicyStore(input: CreatePolicyStoreRequest): CreatePolicyStoreResponse

    /**
     * Creates a policy template. A template can use placeholders for the principal and resource. A template must be instantiated into a policy by associating it with specific principals and resources to use for the placeholders. That instantiated policy can then be considered in authorization decisions. The instantiated policy works identically to any other policy, except that it is dynamically linked to the template. If the template changes, then any policies that are linked to that template are immediately updated as well.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun createPolicyTemplate(input: CreatePolicyTemplateRequest): CreatePolicyTemplateResponse

    /**
     * Deletes an identity source that references an identity provider (IdP) such as Amazon Cognito. After you delete the identity source, you can no longer use tokens for identities from that identity source to represent principals in authorization queries made using [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html). operations.
     */
    public suspend fun deleteIdentitySource(input: DeleteIdentitySourceRequest): DeleteIdentitySourceResponse

    /**
     * Deletes the specified policy from the policy store.
     *
     * This operation is idempotent; if you specify a policy that doesn't exist, the request response returns a successful `HTTP 200` status code.
     */
    public suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Deletes the specified policy store.
     *
     * This operation is idempotent. If you specify a policy store that does not exist, the request response will still return a successful HTTP 200 status code.
     */
    public suspend fun deletePolicyStore(input: DeletePolicyStoreRequest): DeletePolicyStoreResponse

    /**
     * Deletes the specified policy template from the policy store.
     *
     * This operation also deletes any policies that were created from the specified policy template. Those policies are immediately removed from all future API responses, and are asynchronously deleted from the policy store.
     */
    public suspend fun deletePolicyTemplate(input: DeletePolicyTemplateRequest): DeletePolicyTemplateResponse

    /**
     * Retrieves the details about the specified identity source.
     */
    public suspend fun getIdentitySource(input: GetIdentitySourceRequest): GetIdentitySourceResponse

    /**
     * Retrieves information about the specified policy.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Retrieves details about a policy store.
     */
    public suspend fun getPolicyStore(input: GetPolicyStoreRequest): GetPolicyStoreResponse

    /**
     * Retrieve the details for the specified policy template in the specified policy store.
     */
    public suspend fun getPolicyTemplate(input: GetPolicyTemplateRequest): GetPolicyTemplateResponse

    /**
     * Retrieve the details for the specified schema in the specified policy store.
     */
    public suspend fun getSchema(input: GetSchemaRequest): GetSchemaResponse

    /**
     * Makes an authorization decision about a service request described in the parameters. The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
     */
    public suspend fun isAuthorized(input: IsAuthorizedRequest): IsAuthorizedResponse

    /**
     * Makes an authorization decision about a service request described in the parameters. The principal in this request comes from an external identity source in the form of an identity token formatted as a [JSON web token (JWT)](https://wikipedia.org/wiki/JSON_Web_Token). The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
     *
     * At this time, Verified Permissions accepts tokens from only Amazon Cognito.
     *
     * Verified Permissions validates each token that is specified in a request by checking its expiration date and its signature.
     *
     * Tokens from an identity source user continue to be usable until they expire. Token revocation and resource deletion have no effect on the validity of a token in your policy store
     */
    public suspend fun isAuthorizedWithToken(input: IsAuthorizedWithTokenRequest): IsAuthorizedWithTokenResponse

    /**
     * Returns a paginated list of all of the identity sources defined in the specified policy store.
     */
    public suspend fun listIdentitySources(input: ListIdentitySourcesRequest): ListIdentitySourcesResponse

    /**
     * Returns a paginated list of all policies stored in the specified policy store.
     */
    public suspend fun listPolicies(input: ListPoliciesRequest): ListPoliciesResponse

    /**
     * Returns a paginated list of all policy stores in the calling Amazon Web Services account.
     */
    public suspend fun listPolicyStores(input: ListPolicyStoresRequest = ListPolicyStoresRequest { }): ListPolicyStoresResponse

    /**
     * Returns a paginated list of all policy templates in the specified policy store.
     */
    public suspend fun listPolicyTemplates(input: ListPolicyTemplatesRequest): ListPolicyTemplatesResponse

    /**
     * Creates or updates the policy schema in the specified policy store. The schema is used to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun putSchema(input: PutSchemaRequest): PutSchemaResponse

    /**
     * Updates the specified identity source to use a new identity provider (IdP), or to change the mapping of identities from the IdP to a different principal entity type.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun updateIdentitySource(input: UpdateIdentitySourceRequest): UpdateIdentitySourceResponse

    /**
     * Modifies a Cedar static policy in the specified policy store. You can change only certain elements of the [UpdatePolicyDefinition](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyInput.html#amazonverifiedpermissions-UpdatePolicy-request-UpdatePolicyDefinition) parameter. You can directly update only static policies. To change a template-linked policy, you must update the template instead, using [UpdatePolicyTemplate](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html).
     *
     * + If policy validation is enabled in the policy store, then updating a static policy causes Verified Permissions to validate the policy against the schema in the policy store. If the updated static policy doesn't pass validation, the operation fails and the update isn't stored.
     * + When you edit a static policy, you can change only certain elements of a static policy:
     *    + The action referenced by the policy.
     *    + A condition clause, such as when and unless.
     * You can't change these elements of a static policy:
     *    + Changing a policy from a static policy to a template-linked policy.
     *    + Changing the effect of a static policy from permit or forbid.
     *    + The principal referenced by a static policy.
     *    + The resource referenced by a static policy.
     * + To update a template-linked policy, you must update the template instead.
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun updatePolicy(input: UpdatePolicyRequest): UpdatePolicyResponse

    /**
     * Modifies the validation setting for a policy store.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun updatePolicyStore(input: UpdatePolicyStoreRequest): UpdatePolicyStoreResponse

    /**
     * Updates the specified policy template. You can update only the description and the some elements of the [policyBody](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html#amazonverifiedpermissions-UpdatePolicyTemplate-request-policyBody).
     *
     * Changes you make to the policy template content are immediately (within the constraints of eventual consistency) reflected in authorization decisions that involve all template-linked policies instantiated from this template.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    public suspend fun updatePolicyTemplate(input: UpdatePolicyTemplateRequest): UpdatePolicyTemplateResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun VerifiedPermissionsClient.withConfig(block: VerifiedPermissionsClient.Config.Builder.() -> Unit): VerifiedPermissionsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultVerifiedPermissionsClient(newConfig)
}

/**
 * Makes a series of decisions about multiple authorization requests for one principal or resource. Each request contains the equivalent content of an `IsAuthorized` request: principal, action, resource, and context. Either the `principal` or the `resource` parameter must be identical across all requests. For example, Verified Permissions won't evaluate a pair of requests where `bob` views `photo1` and `alice` views `photo2`. Authorization of `bob` to view `photo1` and `photo2`, or `bob` and `alice` to view `photo1`, are valid batches.
 *
 * The request is evaluated against all policies in the specified policy store that match the entities that you declare. The result of the decisions is a series of `Allow` or `Deny` responses, along with the IDs of the policies that produced each decision.
 *
 * The `entities` of a `BatchIsAuthorized` API request can contain up to 100 principals and up to 100 resources. The `requests` of a `BatchIsAuthorized` API request can contain up to 30 requests.
 *
 * The `BatchIsAuthorized` operation doesn't have its own IAM permission. To authorize this operation for Amazon Web Services principals, include the permission `verifiedpermissions:IsAuthorized` in their IAM policies.
 */
public suspend inline fun VerifiedPermissionsClient.batchIsAuthorized(crossinline block: BatchIsAuthorizedRequest.Builder.() -> Unit): BatchIsAuthorizedResponse = batchIsAuthorized(BatchIsAuthorizedRequest.Builder().apply(block).build())

/**
 * Makes a series of decisions about multiple authorization requests for one token. The principal in this request comes from an external identity source in the form of an identity or access token, formatted as a [JSON web token (JWT)](https://wikipedia.org/wiki/JSON_Web_Token). The information in the parameters can also define additional context that Verified Permissions can include in the evaluations.
 *
 * The request is evaluated against all policies in the specified policy store that match the entities that you provide in the entities declaration and in the token. The result of the decisions is a series of `Allow` or `Deny` responses, along with the IDs of the policies that produced each decision.
 *
 * The `entities` of a `BatchIsAuthorizedWithToken` API request can contain up to 100 resources and up to 99 user groups. The `requests` of a `BatchIsAuthorizedWithToken` API request can contain up to 30 requests.
 *
 * The `BatchIsAuthorizedWithToken` operation doesn't have its own IAM permission. To authorize this operation for Amazon Web Services principals, include the permission `verifiedpermissions:IsAuthorizedWithToken` in their IAM policies.
 */
public suspend inline fun VerifiedPermissionsClient.batchIsAuthorizedWithToken(crossinline block: BatchIsAuthorizedWithTokenRequest.Builder.() -> Unit): BatchIsAuthorizedWithTokenResponse = batchIsAuthorizedWithToken(BatchIsAuthorizedWithTokenRequest.Builder().apply(block).build())

/**
 * Adds an identity source to a policy store–an Amazon Cognito user pool or OpenID Connect (OIDC) identity provider (IdP).
 *
 * After you create an identity source, you can use the identities provided by the IdP as proxies for the principal in authorization queries that use the [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html) or [BatchIsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorizedWithToken.html) API operations. These identities take the form of tokens that contain claims about the user, such as IDs, attributes and group memberships. Identity sources provide identity (ID) tokens and access tokens. Verified Permissions derives information about your user and session from token claims. Access tokens provide action `context` to your policies, and ID tokens provide principal `Attributes`.
 *
 * Tokens from an identity source user continue to be usable until they expire. Token revocation and resource deletion have no effect on the validity of a token in your policy store
 *
 * To reference a user from this identity source in your Cedar policies, refer to the following syntax examples.
 * + Amazon Cognito user pool: `Namespace::[Entity type]::[User pool ID]|[user principal attribute]`, for example `MyCorp::User::us-east-1_EXAMPLE|a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`.
 * + OpenID Connect (OIDC) provider: `Namespace::[Entity type]::[principalIdClaim]|[user principal attribute]`, for example `MyCorp::User::MyOIDCProvider|a1b2c3d4-5678-90ab-cdef-EXAMPLE22222`.
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.createIdentitySource(crossinline block: CreateIdentitySourceRequest.Builder.() -> Unit): CreateIdentitySourceResponse = createIdentitySource(CreateIdentitySourceRequest.Builder().apply(block).build())

/**
 * Creates a Cedar policy and saves it in the specified policy store. You can create either a static policy or a policy linked to a policy template.
 * + To create a static policy, provide the Cedar policy text in the `StaticPolicy` section of the `PolicyDefinition`.
 * + To create a policy that is dynamically linked to a policy template, specify the policy template ID and the principal and resource to associate with this policy in the `templateLinked` section of the `PolicyDefinition`. If the policy template is ever updated, any policies linked to the policy template automatically use the updated template.
 *
 * Creating a policy causes it to be validated against the schema in the policy store. If the policy doesn't pass validation, the operation fails and the policy isn't stored.
 *
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.createPolicy(crossinline block: CreatePolicyRequest.Builder.() -> Unit): CreatePolicyResponse = createPolicy(CreatePolicyRequest.Builder().apply(block).build())

/**
 * Creates a policy store. A policy store is a container for policy resources.
 *
 * Although [Cedar supports multiple namespaces](https://docs.cedarpolicy.com/schema/schema.html#namespace), Verified Permissions currently supports only one namespace per policy store.
 *
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.createPolicyStore(crossinline block: CreatePolicyStoreRequest.Builder.() -> Unit): CreatePolicyStoreResponse = createPolicyStore(CreatePolicyStoreRequest.Builder().apply(block).build())

/**
 * Creates a policy template. A template can use placeholders for the principal and resource. A template must be instantiated into a policy by associating it with specific principals and resources to use for the placeholders. That instantiated policy can then be considered in authorization decisions. The instantiated policy works identically to any other policy, except that it is dynamically linked to the template. If the template changes, then any policies that are linked to that template are immediately updated as well.
 *
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.createPolicyTemplate(crossinline block: CreatePolicyTemplateRequest.Builder.() -> Unit): CreatePolicyTemplateResponse = createPolicyTemplate(CreatePolicyTemplateRequest.Builder().apply(block).build())

/**
 * Deletes an identity source that references an identity provider (IdP) such as Amazon Cognito. After you delete the identity source, you can no longer use tokens for identities from that identity source to represent principals in authorization queries made using [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html). operations.
 */
public suspend inline fun VerifiedPermissionsClient.deleteIdentitySource(crossinline block: DeleteIdentitySourceRequest.Builder.() -> Unit): DeleteIdentitySourceResponse = deleteIdentitySource(DeleteIdentitySourceRequest.Builder().apply(block).build())

/**
 * Deletes the specified policy from the policy store.
 *
 * This operation is idempotent; if you specify a policy that doesn't exist, the request response returns a successful `HTTP 200` status code.
 */
public suspend inline fun VerifiedPermissionsClient.deletePolicy(crossinline block: DeletePolicyRequest.Builder.() -> Unit): DeletePolicyResponse = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified policy store.
 *
 * This operation is idempotent. If you specify a policy store that does not exist, the request response will still return a successful HTTP 200 status code.
 */
public suspend inline fun VerifiedPermissionsClient.deletePolicyStore(crossinline block: DeletePolicyStoreRequest.Builder.() -> Unit): DeletePolicyStoreResponse = deletePolicyStore(DeletePolicyStoreRequest.Builder().apply(block).build())

/**
 * Deletes the specified policy template from the policy store.
 *
 * This operation also deletes any policies that were created from the specified policy template. Those policies are immediately removed from all future API responses, and are asynchronously deleted from the policy store.
 */
public suspend inline fun VerifiedPermissionsClient.deletePolicyTemplate(crossinline block: DeletePolicyTemplateRequest.Builder.() -> Unit): DeletePolicyTemplateResponse = deletePolicyTemplate(DeletePolicyTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves the details about the specified identity source.
 */
public suspend inline fun VerifiedPermissionsClient.getIdentitySource(crossinline block: GetIdentitySourceRequest.Builder.() -> Unit): GetIdentitySourceResponse = getIdentitySource(GetIdentitySourceRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified policy.
 */
public suspend inline fun VerifiedPermissionsClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves details about a policy store.
 */
public suspend inline fun VerifiedPermissionsClient.getPolicyStore(crossinline block: GetPolicyStoreRequest.Builder.() -> Unit): GetPolicyStoreResponse = getPolicyStore(GetPolicyStoreRequest.Builder().apply(block).build())

/**
 * Retrieve the details for the specified policy template in the specified policy store.
 */
public suspend inline fun VerifiedPermissionsClient.getPolicyTemplate(crossinline block: GetPolicyTemplateRequest.Builder.() -> Unit): GetPolicyTemplateResponse = getPolicyTemplate(GetPolicyTemplateRequest.Builder().apply(block).build())

/**
 * Retrieve the details for the specified schema in the specified policy store.
 */
public suspend inline fun VerifiedPermissionsClient.getSchema(crossinline block: GetSchemaRequest.Builder.() -> Unit): GetSchemaResponse = getSchema(GetSchemaRequest.Builder().apply(block).build())

/**
 * Makes an authorization decision about a service request described in the parameters. The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
 */
public suspend inline fun VerifiedPermissionsClient.isAuthorized(crossinline block: IsAuthorizedRequest.Builder.() -> Unit): IsAuthorizedResponse = isAuthorized(IsAuthorizedRequest.Builder().apply(block).build())

/**
 * Makes an authorization decision about a service request described in the parameters. The principal in this request comes from an external identity source in the form of an identity token formatted as a [JSON web token (JWT)](https://wikipedia.org/wiki/JSON_Web_Token). The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
 *
 * At this time, Verified Permissions accepts tokens from only Amazon Cognito.
 *
 * Verified Permissions validates each token that is specified in a request by checking its expiration date and its signature.
 *
 * Tokens from an identity source user continue to be usable until they expire. Token revocation and resource deletion have no effect on the validity of a token in your policy store
 */
public suspend inline fun VerifiedPermissionsClient.isAuthorizedWithToken(crossinline block: IsAuthorizedWithTokenRequest.Builder.() -> Unit): IsAuthorizedWithTokenResponse = isAuthorizedWithToken(IsAuthorizedWithTokenRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of all of the identity sources defined in the specified policy store.
 */
public suspend inline fun VerifiedPermissionsClient.listIdentitySources(crossinline block: ListIdentitySourcesRequest.Builder.() -> Unit): ListIdentitySourcesResponse = listIdentitySources(ListIdentitySourcesRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of all policies stored in the specified policy store.
 */
public suspend inline fun VerifiedPermissionsClient.listPolicies(crossinline block: ListPoliciesRequest.Builder.() -> Unit): ListPoliciesResponse = listPolicies(ListPoliciesRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of all policy stores in the calling Amazon Web Services account.
 */
public suspend inline fun VerifiedPermissionsClient.listPolicyStores(crossinline block: ListPolicyStoresRequest.Builder.() -> Unit): ListPolicyStoresResponse = listPolicyStores(ListPolicyStoresRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of all policy templates in the specified policy store.
 */
public suspend inline fun VerifiedPermissionsClient.listPolicyTemplates(crossinline block: ListPolicyTemplatesRequest.Builder.() -> Unit): ListPolicyTemplatesResponse = listPolicyTemplates(ListPolicyTemplatesRequest.Builder().apply(block).build())

/**
 * Creates or updates the policy schema in the specified policy store. The schema is used to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
 *
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.putSchema(crossinline block: PutSchemaRequest.Builder.() -> Unit): PutSchemaResponse = putSchema(PutSchemaRequest.Builder().apply(block).build())

/**
 * Updates the specified identity source to use a new identity provider (IdP), or to change the mapping of identities from the IdP to a different principal entity type.
 *
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.updateIdentitySource(crossinline block: UpdateIdentitySourceRequest.Builder.() -> Unit): UpdateIdentitySourceResponse = updateIdentitySource(UpdateIdentitySourceRequest.Builder().apply(block).build())

/**
 * Modifies a Cedar static policy in the specified policy store. You can change only certain elements of the [UpdatePolicyDefinition](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyInput.html#amazonverifiedpermissions-UpdatePolicy-request-UpdatePolicyDefinition) parameter. You can directly update only static policies. To change a template-linked policy, you must update the template instead, using [UpdatePolicyTemplate](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html).
 *
 * + If policy validation is enabled in the policy store, then updating a static policy causes Verified Permissions to validate the policy against the schema in the policy store. If the updated static policy doesn't pass validation, the operation fails and the update isn't stored.
 * + When you edit a static policy, you can change only certain elements of a static policy:
 *    + The action referenced by the policy.
 *    + A condition clause, such as when and unless.
 * You can't change these elements of a static policy:
 *    + Changing a policy from a static policy to a template-linked policy.
 *    + Changing the effect of a static policy from permit or forbid.
 *    + The principal referenced by a static policy.
 *    + The resource referenced by a static policy.
 * + To update a template-linked policy, you must update the template instead.
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.updatePolicy(crossinline block: UpdatePolicyRequest.Builder.() -> Unit): UpdatePolicyResponse = updatePolicy(UpdatePolicyRequest.Builder().apply(block).build())

/**
 * Modifies the validation setting for a policy store.
 *
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.updatePolicyStore(crossinline block: UpdatePolicyStoreRequest.Builder.() -> Unit): UpdatePolicyStoreResponse = updatePolicyStore(UpdatePolicyStoreRequest.Builder().apply(block).build())

/**
 * Updates the specified policy template. You can update only the description and the some elements of the [policyBody](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html#amazonverifiedpermissions-UpdatePolicyTemplate-request-policyBody).
 *
 * Changes you make to the policy template content are immediately (within the constraints of eventual consistency) reflected in authorization decisions that involve all template-linked policies instantiated from this template.
 *
 * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
 */
public suspend inline fun VerifiedPermissionsClient.updatePolicyTemplate(crossinline block: UpdatePolicyTemplateRequest.Builder.() -> Unit): UpdatePolicyTemplateResponse = updatePolicyTemplate(UpdatePolicyTemplateRequest.Builder().apply(block).build())
