// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about a policy template
 *
 * This data type is used as a response parameter for the [ListPolicyTemplates](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicyTemplates.html) operation.
 */
public class PolicyTemplateItem private constructor(builder: Builder) {
    /**
     * The date and time that the policy template was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * The description attached to the policy template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The date and time that the policy template was most recently updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedDate) { "A non-null value must be provided for lastUpdatedDate" }
    /**
     * The unique identifier of the policy store that contains the template.
     */
    public val policyStoreId: kotlin.String = requireNotNull(builder.policyStoreId) { "A non-null value must be provided for policyStoreId" }
    /**
     * The unique identifier of the policy template.
     */
    public val policyTemplateId: kotlin.String = requireNotNull(builder.policyTemplateId) { "A non-null value must be provided for policyTemplateId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyTemplateItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyTemplateItem(")
        append("createdDate=$createdDate,")
        append("description=*** Sensitive Data Redacted ***,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("policyStoreId=$policyStoreId,")
        append("policyTemplateId=$policyTemplateId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate.hashCode())
        result = 31 * result + (policyStoreId.hashCode())
        result = 31 * result + (policyTemplateId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyTemplateItem

        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (policyStoreId != other.policyStoreId) return false
        if (policyTemplateId != other.policyTemplateId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyTemplateItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that the policy template was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description attached to the policy template.
         */
        public var description: kotlin.String? = null
        /**
         * The date and time that the policy template was most recently updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the policy store that contains the template.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * The unique identifier of the policy template.
         */
        public var policyTemplateId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyTemplateItem) : this() {
            this.createdDate = x.createdDate
            this.description = x.description
            this.lastUpdatedDate = x.lastUpdatedDate
            this.policyStoreId = x.policyStoreId
            this.policyTemplateId = x.policyTemplateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyTemplateItem = PolicyTemplateItem(this)

        internal fun correctErrors(): Builder {
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (lastUpdatedDate == null) lastUpdatedDate = Instant.fromEpochSeconds(0)
            if (policyStoreId == null) policyStoreId = ""
            if (policyTemplateId == null) policyTemplateId = ""
            return this
        }
    }
}
