// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * A structure that contains the details for a Cedar policy definition. It includes the policy type, a description, and a policy body. This is a top level data type used to create a policy.
 *
 * This data type is used as a request parameter for the [CreatePolicy](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html) operation. This structure must always have either an `static` or a `templateLinked` element.
 */
public sealed class PolicyDefinition {
    /**
     * A structure that describes a static policy. An static policy doesn't use a template or allow placeholders for entities.
     */
    public data class Static(val value: aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinition) : aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinition() {
    }

    /**
     * A structure that describes a policy that was instantiated from a template. The template can specify placeholders for `principal` and `resource`. When you use [CreatePolicy](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html) to create a policy from a template, you specify the exact principal and resource to use for the instantiated policy.
     */
    public data class TemplateLinked(val value: aws.sdk.kotlin.services.verifiedpermissions.model.TemplateLinkedPolicyDefinition) : aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinition() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinition() {
    }

    /**
     * Casts this [PolicyDefinition] as a [Static] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinition] value. Throws an exception if the [PolicyDefinition] is not a
     * [Static].
     */
    public fun asStatic(): aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinition = (this as PolicyDefinition.Static).value

    /**
     * Casts this [PolicyDefinition] as a [Static] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinition] value. Returns null if the [PolicyDefinition] is not a [Static].
     */
    public fun asStaticOrNull(): aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinition? = (this as? PolicyDefinition.Static)?.value

    /**
     * Casts this [PolicyDefinition] as a [TemplateLinked] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.TemplateLinkedPolicyDefinition] value. Throws an exception if the [PolicyDefinition] is not a
     * [TemplateLinked].
     */
    public fun asTemplateLinked(): aws.sdk.kotlin.services.verifiedpermissions.model.TemplateLinkedPolicyDefinition = (this as PolicyDefinition.TemplateLinked).value

    /**
     * Casts this [PolicyDefinition] as a [TemplateLinked] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.TemplateLinkedPolicyDefinition] value. Returns null if the [PolicyDefinition] is not a [TemplateLinked].
     */
    public fun asTemplateLinkedOrNull(): aws.sdk.kotlin.services.verifiedpermissions.model.TemplateLinkedPolicyDefinition? = (this as? PolicyDefinition.TemplateLinked)?.value
}
