// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * The value of an attribute.
 *
 * Contains information about the runtime context for a request for which an authorization decision is made.
 *
 * This data type is used as a member of the [ContextDefinition](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ContextDefinition.html) structure which is uses as a request parameter for the [IsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html), [BatchIsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html), and [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html) operations.
 */
public sealed class AttributeValue {
    /**
     * An attribute value of [Boolean](https://docs.cedarpolicy.com/policies/syntax-datatypes.html#boolean) type.
     *
     * Example: `{"boolean": true}`
     */
    public data class Boolean(val value: kotlin.Boolean) : aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue() {
    }

    /**
     * An attribute value of type [EntityIdentifier](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_EntityIdentifier.html).
     *
     * Example: `"entityIdentifier": { "entityId": "&lt;id&gt;", "entityType": "&lt;entity type&gt;"}`
     */
    public data class EntityIdentifier(val value: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier) : aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue() {
    }

    /**
     * An attribute value of [Long](https://docs.cedarpolicy.com/policies/syntax-datatypes.html#long) type.
     *
     * Example: `{"long": 0}`
     */
    public data class Long(val value: kotlin.Long) : aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue() {
    }

    /**
     * An attribute value of [Record](https://docs.cedarpolicy.com/policies/syntax-datatypes.html#record) type.
     *
     * Example: `{"record": { "keyName": {} } }`
     */
    public data class Record(val value: Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>) : aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue() {
    }

    /**
     * An attribute value of [Set](https://docs.cedarpolicy.com/policies/syntax-datatypes.html#set) type.
     *
     * Example: `{"set": [ {} ] }`
     */
    public data class Set(val value: List<aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>) : aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue() {
    }

    /**
     * An attribute value of [String](https://docs.cedarpolicy.com/policies/syntax-datatypes.html#string) type.
     *
     * Example: `{"string": "abc"}`
     */
    public data class String(val value: kotlin.String) : aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue() {
    }

    /**
     * Casts this [AttributeValue] as a [Boolean] and retrieves its [kotlin.Boolean] value. Throws an exception if the [AttributeValue] is not a
     * [Boolean].
     */
    public fun asBoolean(): kotlin.Boolean = (this as AttributeValue.Boolean).value

    /**
     * Casts this [AttributeValue] as a [Boolean] and retrieves its [kotlin.Boolean] value. Returns null if the [AttributeValue] is not a [Boolean].
     */
    public fun asBooleanOrNull(): kotlin.Boolean? = (this as? AttributeValue.Boolean)?.value

    /**
     * Casts this [AttributeValue] as a [EntityIdentifier] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] value. Throws an exception if the [AttributeValue] is not a
     * [EntityIdentifier].
     */
    public fun asEntityIdentifier(): aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier = (this as AttributeValue.EntityIdentifier).value

    /**
     * Casts this [AttributeValue] as a [EntityIdentifier] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] value. Returns null if the [AttributeValue] is not a [EntityIdentifier].
     */
    public fun asEntityIdentifierOrNull(): aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = (this as? AttributeValue.EntityIdentifier)?.value

    /**
     * Casts this [AttributeValue] as a [Long] and retrieves its [kotlin.Long] value. Throws an exception if the [AttributeValue] is not a
     * [Long].
     */
    public fun asLong(): kotlin.Long = (this as AttributeValue.Long).value

    /**
     * Casts this [AttributeValue] as a [Long] and retrieves its [kotlin.Long] value. Returns null if the [AttributeValue] is not a [Long].
     */
    public fun asLongOrNull(): kotlin.Long? = (this as? AttributeValue.Long)?.value

    /**
     * Casts this [AttributeValue] as a [Record] and retrieves its [Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>] value. Throws an exception if the [AttributeValue] is not a
     * [Record].
     */
    public fun asRecord(): Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue> = (this as AttributeValue.Record).value

    /**
     * Casts this [AttributeValue] as a [Record] and retrieves its [Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>] value. Returns null if the [AttributeValue] is not a [Record].
     */
    public fun asRecordOrNull(): Map<kotlin.String, aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>? = (this as? AttributeValue.Record)?.value

    /**
     * Casts this [AttributeValue] as a [Set] and retrieves its [List<aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>] value. Throws an exception if the [AttributeValue] is not a
     * [Set].
     */
    public fun asSet(): List<aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue> = (this as AttributeValue.Set).value

    /**
     * Casts this [AttributeValue] as a [Set] and retrieves its [List<aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>] value. Returns null if the [AttributeValue] is not a [Set].
     */
    public fun asSetOrNull(): List<aws.sdk.kotlin.services.verifiedpermissions.model.AttributeValue>? = (this as? AttributeValue.Set)?.value

    /**
     * Casts this [AttributeValue] as a [String] and retrieves its [kotlin.String] value. Throws an exception if the [AttributeValue] is not a
     * [String].
     */
    public fun asString(): kotlin.String = (this as AttributeValue.String).value

    /**
     * Casts this [AttributeValue] as a [String] and retrieves its [kotlin.String] value. Returns null if the [AttributeValue] is not a [String].
     */
    public fun asStringOrNull(): kotlin.String? = (this as? AttributeValue.String)?.value
}
