// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetPolicyResponse private constructor(builder: Builder) {
    /**
     * The date and time that the policy was originally created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * The definition of the requested policy.
     */
    public val definition: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinitionDetail? = builder.definition
    /**
     * The date and time that the policy was last updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedDate) { "A non-null value must be provided for lastUpdatedDate" }
    /**
     * The unique ID of the policy that you want information about.
     */
    public val policyId: kotlin.String = requireNotNull(builder.policyId) { "A non-null value must be provided for policyId" }
    /**
     * The ID of the policy store that contains the policy that you want information about.
     */
    public val policyStoreId: kotlin.String = requireNotNull(builder.policyStoreId) { "A non-null value must be provided for policyStoreId" }
    /**
     * The type of the policy.
     */
    public val policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType = requireNotNull(builder.policyType) { "A non-null value must be provided for policyType" }
    /**
     * The principal specified in the policy's scope. This element isn't included in the response when `Principal` isn't present in the policy content.
     */
    public val principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.principal
    /**
     * The resource specified in the policy's scope. This element isn't included in the response when `Resource` isn't present in the policy content.
     */
    public val resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPolicyResponse(")
        append("createdDate=$createdDate,")
        append("definition=$definition,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("policyId=$policyId,")
        append("policyStoreId=$policyStoreId,")
        append("policyType=$policyType,")
        append("principal=$principal,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate.hashCode()
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate.hashCode())
        result = 31 * result + (policyId.hashCode())
        result = 31 * result + (policyStoreId.hashCode())
        result = 31 * result + (policyType.hashCode())
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPolicyResponse

        if (createdDate != other.createdDate) return false
        if (definition != other.definition) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (policyId != other.policyId) return false
        if (policyStoreId != other.policyStoreId) return false
        if (policyType != other.policyType) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that the policy was originally created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The definition of the requested policy.
         */
        public var definition: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinitionDetail? = null
        /**
         * The date and time that the policy was last updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID of the policy that you want information about.
         */
        public var policyId: kotlin.String? = null
        /**
         * The ID of the policy store that contains the policy that you want information about.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * The type of the policy.
         */
        public var policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType? = null
        /**
         * The principal specified in the policy's scope. This element isn't included in the response when `Principal` isn't present in the policy content.
         */
        public var principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null
        /**
         * The resource specified in the policy's scope. This element isn't included in the response when `Resource` isn't present in the policy content.
         */
        public var resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyResponse) : this() {
            this.createdDate = x.createdDate
            this.definition = x.definition
            this.lastUpdatedDate = x.lastUpdatedDate
            this.policyId = x.policyId
            this.policyStoreId = x.policyStoreId
            this.policyType = x.policyType
            this.principal = x.principal
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.GetPolicyResponse = GetPolicyResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun principal(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.principal = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (lastUpdatedDate == null) lastUpdatedDate = Instant.fromEpochSeconds(0)
            if (policyId == null) policyId = ""
            if (policyStoreId == null) policyStoreId = ""
            if (policyType == null) policyType = PolicyType.SdkUnknown("no value provided")
            return this
        }
    }
}
