// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.serde

import aws.sdk.kotlin.services.verifiedpermissions.model.Decision
import aws.sdk.kotlin.services.verifiedpermissions.model.DeterminingPolicyItem
import aws.sdk.kotlin.services.verifiedpermissions.model.EvaluationErrorItem
import aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedWithTokenResponse
import aws.sdk.kotlin.services.verifiedpermissions.model.VerifiedPermissionsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class IsAuthorizedWithTokenOperationDeserializer: HttpDeserialize<IsAuthorizedWithTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): IsAuthorizedWithTokenResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwIsAuthorizedWithTokenError(context, call)
        }
        val builder = IsAuthorizedWithTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeIsAuthorizedWithTokenOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwIsAuthorizedWithTokenError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw VerifiedPermissionsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> VerifiedPermissionsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeIsAuthorizedWithTokenOperationBody(builder: IsAuthorizedWithTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DECISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("decision"))
    val DETERMININGPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("determiningPolicies"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DECISION_DESCRIPTOR)
        field(DETERMININGPOLICIES_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DECISION_DESCRIPTOR.index -> builder.decision = deserializeString().let { Decision.fromValue(it) }
                DETERMININGPOLICIES_DESCRIPTOR.index -> builder.determiningPolicies =
                    deserializer.deserializeList(DETERMININGPOLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<DeterminingPolicyItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeterminingPolicyItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<EvaluationErrorItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEvaluationErrorItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
