// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * A structure that contains Cedar policy validation settings for the policy store. The validation mode determines which validation failures that Cedar considers serious enough to block acceptance of a new or edited static policy or policy template.
 *
 * This data type is used as a request parameter in the [CreatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicyStore.html) and [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore.html) operations.
 */
public class ValidationSettings private constructor(builder: Builder) {
    /**
     * The validation mode currently configured for this policy store. The valid values are:
     * + **OFF** – Neither Verified Permissions nor Cedar perform any validation on policies. No validation errors are reported by either service.
     * + **STRICT** – Requires a schema to be present in the policy store. Cedar performs validation on all submitted new or updated static policies and policy templates. Any that fail validation are rejected and Cedar doesn't store them in the policy store.
     *
     * If `Mode=STRICT` and the policy store doesn't contain a schema, Verified Permissions rejects all static policies and policy templates because there is no schema to validate against.
     *
     * To submit a static policy or policy template without a schema, you must turn off validation.
     */
    public val mode: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationMode = requireNotNull(builder.mode) { "A non-null value must be provided for mode" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidationSettings(")
        append("mode=$mode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = mode.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidationSettings

        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The validation mode currently configured for this policy store. The valid values are:
         * + **OFF** – Neither Verified Permissions nor Cedar perform any validation on policies. No validation errors are reported by either service.
         * + **STRICT** – Requires a schema to be present in the policy store. Cedar performs validation on all submitted new or updated static policies and policy templates. Any that fail validation are rejected and Cedar doesn't store them in the policy store.
         *
         * If `Mode=STRICT` and the policy store doesn't contain a schema, Verified Permissions rejects all static policies and policy templates because there is no schema to validate against.
         *
         * To submit a static policy or policy template without a schema, you must turn off validation.
         */
        public var mode: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings) : this() {
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings = ValidationSettings(this)

        internal fun correctErrors(): Builder {
            if (mode == null) mode = ValidationMode.SdkUnknown("no value provided")
            return this
        }
    }
}
