// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



public class UpdatePolicyRequest private constructor(builder: Builder) {
    /**
     * Specifies the updated policy content that you want to replace on the specified policy. The content must be valid Cedar policy language text.
     *
     * You can change only the following elements from the policy definition:
     * + The `action` referenced by the policy.
     * + Any conditional clauses, such as `when` or `unless` clauses.
     *
     * You **can't** change the following elements:
     * + Changing from `static` to `templateLinked`.
     * + Changing the effect of the policy from `permit` or `forbid`.
     * + The `principal` referenced by the policy.
     * + The `resource` referenced by the policy.
     */
    public val definition: aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyDefinition? = builder.definition
    /**
     * Specifies the ID of the policy that you want to update. To find this value, you can use [ListPolicies](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html).
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * Specifies the ID of the policy store that contains the policy that you want to update.
     */
    public val policyStoreId: kotlin.String? = builder.policyStoreId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePolicyRequest(")
        append("definition=$definition,")
        append("policyId=$policyId,")
        append("policyStoreId=$policyStoreId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyStoreId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePolicyRequest

        if (definition != other.definition) return false
        if (policyId != other.policyId) return false
        if (policyStoreId != other.policyStoreId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the updated policy content that you want to replace on the specified policy. The content must be valid Cedar policy language text.
         *
         * You can change only the following elements from the policy definition:
         * + The `action` referenced by the policy.
         * + Any conditional clauses, such as `when` or `unless` clauses.
         *
         * You **can't** change the following elements:
         * + Changing from `static` to `templateLinked`.
         * + Changing the effect of the policy from `permit` or `forbid`.
         * + The `principal` referenced by the policy.
         * + The `resource` referenced by the policy.
         */
        public var definition: aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyDefinition? = null
        /**
         * Specifies the ID of the policy that you want to update. To find this value, you can use [ListPolicies](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html).
         */
        public var policyId: kotlin.String? = null
        /**
         * Specifies the ID of the policy store that contains the policy that you want to update.
         */
        public var policyStoreId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyRequest) : this() {
            this.definition = x.definition
            this.policyId = x.policyId
            this.policyStoreId = x.policyStoreId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.UpdatePolicyRequest = UpdatePolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
