// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * A structure that contains details about a static policy. It includes the description and policy body.
 *
 * This data type is used within a [PolicyDefinition](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinition.html) structure as part of a request parameter for the [CreatePolicy](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html) operation.
 */
public class StaticPolicyDefinitionDetail private constructor(builder: Builder) {
    /**
     * A description of the static policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The content of the static policy written in the Cedar policy language.
     */
    public val statement: kotlin.String = requireNotNull(builder.statement) { "A non-null value must be provided for statement" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinitionDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StaticPolicyDefinitionDetail(")
        append("description=*** Sensitive Data Redacted ***,")
        append("statement=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (statement.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StaticPolicyDefinitionDetail

        if (description != other.description) return false
        if (statement != other.statement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinitionDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the static policy.
         */
        public var description: kotlin.String? = null
        /**
         * The content of the static policy written in the Cedar policy language.
         */
        public var statement: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinitionDetail) : this() {
            this.description = x.description
            this.statement = x.statement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.StaticPolicyDefinitionDetail = StaticPolicyDefinitionDetail(this)

        internal fun correctErrors(): Builder {
            if (statement == null) statement = ""
            return this
        }
    }
}
