// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



public class IsAuthorizedWithTokenRequest private constructor(builder: Builder) {
    /**
     * Specifies an access token for the principal to be authorized. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
     *
     * Must be an access token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `access`.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * Specifies the requested action to be authorized. Is the specified principal authorized to perform this action on the specified resource.
     */
    public val action: aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier? = builder.action
    /**
     * Specifies additional context that can be used to make more granular authorization decisions.
     */
    public val context: aws.sdk.kotlin.services.verifiedpermissions.model.ContextDefinition? = builder.context
    /**
     * Specifies the list of resources and their associated attributes that Verified Permissions can examine when evaluating the policies.
     *
     * You can include only resource and action entities in this parameter; you can't include principals.
     * + The `IsAuthorizedWithToken` operation takes principal attributes from ***only*** the `identityToken` or `accessToken` passed to the operation.
     * + For action entities, you can include only their `Identifier` and `EntityType`.
     */
    public val entities: aws.sdk.kotlin.services.verifiedpermissions.model.EntitiesDefinition? = builder.entities
    /**
     * Specifies an identity token for the principal to be authorized. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
     *
     * Must be an ID token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `id`.
     */
    public val identityToken: kotlin.String? = builder.identityToken
    /**
     * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization decision for the input.
     */
    public val policyStoreId: kotlin.String? = builder.policyStoreId
    /**
     * Specifies the resource for which the authorization decision is made. For example, is the principal allowed to perform the action on the resource?
     */
    public val resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedWithTokenRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IsAuthorizedWithTokenRequest(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("action=$action,")
        append("context=$context,")
        append("entities=$entities,")
        append("identityToken=*** Sensitive Data Redacted ***,")
        append("policyStoreId=$policyStoreId,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (action?.hashCode() ?: 0)
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (entities?.hashCode() ?: 0)
        result = 31 * result + (identityToken?.hashCode() ?: 0)
        result = 31 * result + (policyStoreId?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IsAuthorizedWithTokenRequest

        if (accessToken != other.accessToken) return false
        if (action != other.action) return false
        if (context != other.context) return false
        if (entities != other.entities) return false
        if (identityToken != other.identityToken) return false
        if (policyStoreId != other.policyStoreId) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedWithTokenRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies an access token for the principal to be authorized. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
         *
         * Must be an access token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `access`.
         */
        public var accessToken: kotlin.String? = null
        /**
         * Specifies the requested action to be authorized. Is the specified principal authorized to perform this action on the specified resource.
         */
        public var action: aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier? = null
        /**
         * Specifies additional context that can be used to make more granular authorization decisions.
         */
        public var context: aws.sdk.kotlin.services.verifiedpermissions.model.ContextDefinition? = null
        /**
         * Specifies the list of resources and their associated attributes that Verified Permissions can examine when evaluating the policies.
         *
         * You can include only resource and action entities in this parameter; you can't include principals.
         * + The `IsAuthorizedWithToken` operation takes principal attributes from ***only*** the `identityToken` or `accessToken` passed to the operation.
         * + For action entities, you can include only their `Identifier` and `EntityType`.
         */
        public var entities: aws.sdk.kotlin.services.verifiedpermissions.model.EntitiesDefinition? = null
        /**
         * Specifies an identity token for the principal to be authorized. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
         *
         * Must be an ID token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `id`.
         */
        public var identityToken: kotlin.String? = null
        /**
         * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization decision for the input.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * Specifies the resource for which the authorization decision is made. For example, is the principal allowed to perform the action on the resource?
         */
        public var resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedWithTokenRequest) : this() {
            this.accessToken = x.accessToken
            this.action = x.action
            this.context = x.context
            this.entities = x.entities
            this.identityToken = x.identityToken
            this.policyStoreId = x.policyStoreId
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.IsAuthorizedWithTokenRequest = IsAuthorizedWithTokenRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier] inside the given [block]
         */
        public fun action(block: aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
