// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * Contains the identifier of an entity, including its ID and type.
 *
 * This data type is used as a request parameter for [IsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html) operation, and as a response parameter for the [CreatePolicy](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html), [GetPolicy](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_GetPolicy.html), and [UpdatePolicy](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicy.html) operations.
 *
 * Example: `{"entityId":"<i>string</i>","entityType":"<i>string</i>"}`
 */
public class EntityIdentifier private constructor(builder: Builder) {
    /**
     * The identifier of an entity.
     *
     * `"entityId":"<i>identifier</i>"`
     */
    public val entityId: kotlin.String = requireNotNull(builder.entityId) { "A non-null value must be provided for entityId" }
    /**
     * The type of an entity.
     *
     * Example: `"entityType":"<i>typeName</i>"`
     */
    public val entityType: kotlin.String = requireNotNull(builder.entityType) { "A non-null value must be provided for entityType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityIdentifier(")
        append("entityId=*** Sensitive Data Redacted ***,")
        append("entityType=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityId.hashCode()
        result = 31 * result + (entityType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityIdentifier

        if (entityId != other.entityId) return false
        if (entityType != other.entityType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of an entity.
         *
         * `"entityId":"<i>identifier</i>"`
         */
        public var entityId: kotlin.String? = null
        /**
         * The type of an entity.
         *
         * Example: `"entityType":"<i>typeName</i>"`
         */
        public var entityType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier) : this() {
            this.entityId = x.entityId
            this.entityType = x.entityType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier = EntityIdentifier(this)

        internal fun correctErrors(): Builder {
            if (entityId == null) entityId = ""
            if (entityType == null) entityType = ""
            return this
        }
    }
}
