// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * Contains information about one of the policies that determined an authorization decision.
 *
 * This data type is used as an element in a response parameter for the [IsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html), [BatchIsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html), and [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html) operations.
 *
 * Example: `"determiningPolicies":[{"policyId":"SPEXAMPLEabcdefg111111"}]`
 */
public class DeterminingPolicyItem private constructor(builder: Builder) {
    /**
     * The Id of a policy that determined to an authorization decision.
     *
     * Example: `"policyId":"SPEXAMPLEabcdefg111111"`
     */
    public val policyId: kotlin.String = requireNotNull(builder.policyId) { "A non-null value must be provided for policyId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.DeterminingPolicyItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeterminingPolicyItem(")
        append("policyId=$policyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyId.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeterminingPolicyItem

        if (policyId != other.policyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.DeterminingPolicyItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Id of a policy that determined to an authorization decision.
         *
         * Example: `"policyId":"SPEXAMPLEabcdefg111111"`
         */
        public var policyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.DeterminingPolicyItem) : this() {
            this.policyId = x.policyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.DeterminingPolicyItem = DeterminingPolicyItem(this)

        internal fun correctErrors(): Builder {
            if (policyId == null) policyId = ""
            return this
        }
    }
}
