// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



public class CreatePolicyStoreRequest private constructor(builder: Builder) {
    /**
     * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value.](https://wikipedia.org/wiki/Universally_unique_identifier).
     *
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     *
     * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `ConflictException` error.
     *
     * Verified Permissions recognizes a `ClientToken` for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of `ClientToken`.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Descriptive text that you can provide to help with identification of the current policy store.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies the validation setting for this policy store.
     *
     * Currently, the only valid and required value is `Mode`.
     *
     * We recommend that you turn on `STRICT` mode only after you define a schema. If a schema doesn't exist, then `STRICT` mode causes any policy to fail validation, and Verified Permissions rejects the policy. You can turn off validation by using the [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore). Then, when you have a schema defined, use [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) again to turn validation back on.
     */
    public val validationSettings: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings? = builder.validationSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePolicyStoreRequest(")
        append("clientToken=$clientToken,")
        append("description=*** Sensitive Data Redacted ***,")
        append("validationSettings=$validationSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (validationSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePolicyStoreRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (validationSettings != other.validationSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyStoreRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value.](https://wikipedia.org/wiki/Universally_unique_identifier).
         *
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         *
         * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `ConflictException` error.
         *
         * Verified Permissions recognizes a `ClientToken` for eight hours. After eight hours, the next request with the same parameters performs the operation again regardless of the value of `ClientToken`.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Descriptive text that you can provide to help with identification of the current policy store.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies the validation setting for this policy store.
         *
         * Currently, the only valid and required value is `Mode`.
         *
         * We recommend that you turn on `STRICT` mode only after you define a schema. If a schema doesn't exist, then `STRICT` mode causes any policy to fail validation, and Verified Permissions rejects the policy. You can turn off validation by using the [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore). Then, when you have a schema defined, use [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) again to turn validation back on.
         */
        public var validationSettings: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyStoreRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.validationSettings = x.validationSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.CreatePolicyStoreRequest = CreatePolicyStoreRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings] inside the given [block]
         */
        public fun validationSettings(block: aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings.Builder.() -> kotlin.Unit) {
            this.validationSettings = aws.sdk.kotlin.services.verifiedpermissions.model.ValidationSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
