// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * Contains configuration information used when creating a new identity source.
 *
 * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
 *
 * You must specify a `userPoolArn`, and optionally, a `ClientId`.
 *
 * This data type is used as a request parameter for the [CreateIdentitySource](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html) operation.
 */
public sealed class Configuration {
    /**
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of authenticated identities as entities. It specifies the [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a Amazon Cognito user pool and one or more application client IDs.
     *
     * Example: `"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}`
     */
    public data class CognitoUserPoolConfiguration(val value: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration) : aws.sdk.kotlin.services.verifiedpermissions.model.Configuration() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.verifiedpermissions.model.Configuration() {
    }

    /**
     * Casts this [Configuration] as a [CognitoUserPoolConfiguration] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration] value. Throws an exception if the [Configuration] is not a
     * [CognitoUserPoolConfiguration].
     */
    public fun asCognitoUserPoolConfiguration(): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration = (this as Configuration.CognitoUserPoolConfiguration).value

    /**
     * Casts this [Configuration] as a [CognitoUserPoolConfiguration] and retrieves its [aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration] value. Returns null if the [Configuration] is not a [CognitoUserPoolConfiguration].
     */
    public fun asCognitoUserPoolConfigurationOrNull(): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfiguration? = (this as? Configuration.CognitoUserPoolConfiguration)?.value
}
