// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * Contains information about an action for a request for which an authorization decision is made.
 *
 * This data type is used as a request parameter to the [IsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorized.html), [BatchIsAuthorized](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_BatchIsAuthorized.html), and [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html) operations.
 *
 * Example: `{ "actionId": "&lt;action name&gt;", "actionType": "Action" }`
 */
public class ActionIdentifier private constructor(builder: Builder) {
    /**
     * The ID of an action.
     */
    public val actionId: kotlin.String = requireNotNull(builder.actionId) { "A non-null value must be provided for actionId" }
    /**
     * The type of an action.
     */
    public val actionType: kotlin.String = requireNotNull(builder.actionType) { "A non-null value must be provided for actionType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionIdentifier(")
        append("actionId=*** Sensitive Data Redacted ***,")
        append("actionType=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId.hashCode()
        result = 31 * result + (actionType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionIdentifier

        if (actionId != other.actionId) return false
        if (actionType != other.actionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of an action.
         */
        public var actionId: kotlin.String? = null
        /**
         * The type of an action.
         */
        public var actionType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier) : this() {
            this.actionId = x.actionId
            this.actionType = x.actionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.ActionIdentifier = ActionIdentifier(this)

        internal fun correctErrors(): Builder {
            if (actionId == null) actionId = ""
            if (actionType == null) actionType = ""
            return this
        }
    }
}
