// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.verifiedpermissions.auth.VerifiedPermissionsAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.verifiedpermissions.auth.VerifiedPermissionsIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.verifiedpermissions.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.verifiedpermissions.model.*
import aws.sdk.kotlin.services.verifiedpermissions.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultVerifiedPermissionsClient(override val config: VerifiedPermissionsClient.Config) : VerifiedPermissionsClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = VerifiedPermissionsIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "verifiedpermissions")
        }
        toMap()
    }
    private val authSchemeAdapter = VerifiedPermissionsAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.verifiedpermissions"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Makes a series of decisions about multiple authorization requests for one principal or resource. Each request contains the equivalent content of an `IsAuthorized` request: principal, action, resource, and context. Either the `principal` or the `resource` parameter must be identical across all requests. For example, Verified Permissions won't evaluate a pair of requests where `bob` views `photo1` and `alice` views `photo2`. Authorization of `bob` to view `photo1` and `photo2`, or `bob` and `alice` to view `photo1`, are valid batches.
     *
     * The request is evaluated against all policies in the specified policy store that match the entities that you declare. The result of the decisions is a series of `Allow` or `Deny` responses, along with the IDs of the policies that produced each decision.
     *
     * The `entities` of a `BatchIsAuthorized` API request can contain up to 100 principals and up to 100 resources. The `requests` of a `BatchIsAuthorized` API request can contain up to 30 requests.
     *
     * The `BatchIsAuthorized` operation doesn't have its own IAM permission. To authorize this operation for Amazon Web Services principals, include the permission `verifiedpermissions:IsAuthorized` in their IAM policies.
     */
    override suspend fun batchIsAuthorized(input: BatchIsAuthorizedRequest): BatchIsAuthorizedResponse {
        val op = SdkHttpOperation.build<BatchIsAuthorizedRequest, BatchIsAuthorizedResponse> {
            serializer = BatchIsAuthorizedOperationSerializer()
            deserializer = BatchIsAuthorizedOperationDeserializer()
            operationName = "BatchIsAuthorized"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a reference to an Amazon Cognito user pool as an external identity provider (IdP).
     *
     * After you create an identity source, you can use the identities provided by the IdP as proxies for the principal in authorization queries that use the [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html) operation. These identities take the form of tokens that contain claims about the user, such as IDs, attributes and group memberships. Amazon Cognito provides both identity tokens and access tokens, and Verified Permissions can use either or both. Any combination of identity and access tokens results in the same Cedar principal. Verified Permissions automatically translates the information about the identities into the standard Cedar attributes that can be evaluated by your policies. Because the Amazon Cognito identity and access tokens can contain different information, the tokens you choose to use determine which principal attributes are available to access when evaluating Cedar policies.
     *
     * If you delete a Amazon Cognito user pool or user, tokens from that deleted pool or that deleted user continue to be usable until they expire.
     *
     * To reference a user from this identity source in your Cedar policies, use the following syntax.
     *
     * *IdentityType::"<CognitoUserPoolIdentifier>|<CognitoClientId>*
     *
     * Where `IdentityType` is the string that you provide to the `PrincipalEntityType` parameter for this operation. The `CognitoUserPoolId` and `CognitoClientId` are defined by the Amazon Cognito user pool.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun createIdentitySource(input: CreateIdentitySourceRequest): CreateIdentitySourceResponse {
        val op = SdkHttpOperation.build<CreateIdentitySourceRequest, CreateIdentitySourceResponse> {
            serializer = CreateIdentitySourceOperationSerializer()
            deserializer = CreateIdentitySourceOperationDeserializer()
            operationName = "CreateIdentitySource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Cedar policy and saves it in the specified policy store. You can create either a static policy or a policy linked to a policy template.
     * + To create a static policy, provide the Cedar policy text in the `StaticPolicy` section of the `PolicyDefinition`.
     * + To create a policy that is dynamically linked to a policy template, specify the policy template ID and the principal and resource to associate with this policy in the `templateLinked` section of the `PolicyDefinition`. If the policy template is ever updated, any policies linked to the policy template automatically use the updated template.
     *
     * Creating a policy causes it to be validated against the schema in the policy store. If the policy doesn't pass validation, the operation fails and the policy isn't stored.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun createPolicy(input: CreatePolicyRequest): CreatePolicyResponse {
        val op = SdkHttpOperation.build<CreatePolicyRequest, CreatePolicyResponse> {
            serializer = CreatePolicyOperationSerializer()
            deserializer = CreatePolicyOperationDeserializer()
            operationName = "CreatePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a policy store. A policy store is a container for policy resources.
     *
     * Although [Cedar supports multiple namespaces](https://docs.cedarpolicy.com/schema/schema.html#namespace), Verified Permissions currently supports only one namespace per policy store.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun createPolicyStore(input: CreatePolicyStoreRequest): CreatePolicyStoreResponse {
        val op = SdkHttpOperation.build<CreatePolicyStoreRequest, CreatePolicyStoreResponse> {
            serializer = CreatePolicyStoreOperationSerializer()
            deserializer = CreatePolicyStoreOperationDeserializer()
            operationName = "CreatePolicyStore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a policy template. A template can use placeholders for the principal and resource. A template must be instantiated into a policy by associating it with specific principals and resources to use for the placeholders. That instantiated policy can then be considered in authorization decisions. The instantiated policy works identically to any other policy, except that it is dynamically linked to the template. If the template changes, then any policies that are linked to that template are immediately updated as well.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun createPolicyTemplate(input: CreatePolicyTemplateRequest): CreatePolicyTemplateResponse {
        val op = SdkHttpOperation.build<CreatePolicyTemplateRequest, CreatePolicyTemplateResponse> {
            serializer = CreatePolicyTemplateOperationSerializer()
            deserializer = CreatePolicyTemplateOperationDeserializer()
            operationName = "CreatePolicyTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an identity source that references an identity provider (IdP) such as Amazon Cognito. After you delete the identity source, you can no longer use tokens for identities from that identity source to represent principals in authorization queries made using [IsAuthorizedWithToken](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_IsAuthorizedWithToken.html). operations.
     */
    override suspend fun deleteIdentitySource(input: DeleteIdentitySourceRequest): DeleteIdentitySourceResponse {
        val op = SdkHttpOperation.build<DeleteIdentitySourceRequest, DeleteIdentitySourceResponse> {
            serializer = DeleteIdentitySourceOperationSerializer()
            deserializer = DeleteIdentitySourceOperationDeserializer()
            operationName = "DeleteIdentitySource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified policy from the policy store.
     *
     * This operation is idempotent; if you specify a policy that doesn't exist, the request response returns a successful `HTTP 200` status code.
     */
    override suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse {
        val op = SdkHttpOperation.build<DeletePolicyRequest, DeletePolicyResponse> {
            serializer = DeletePolicyOperationSerializer()
            deserializer = DeletePolicyOperationDeserializer()
            operationName = "DeletePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified policy store.
     *
     * This operation is idempotent. If you specify a policy store that does not exist, the request response will still return a successful HTTP 200 status code.
     */
    override suspend fun deletePolicyStore(input: DeletePolicyStoreRequest): DeletePolicyStoreResponse {
        val op = SdkHttpOperation.build<DeletePolicyStoreRequest, DeletePolicyStoreResponse> {
            serializer = DeletePolicyStoreOperationSerializer()
            deserializer = DeletePolicyStoreOperationDeserializer()
            operationName = "DeletePolicyStore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified policy template from the policy store.
     *
     * This operation also deletes any policies that were created from the specified policy template. Those policies are immediately removed from all future API responses, and are asynchronously deleted from the policy store.
     */
    override suspend fun deletePolicyTemplate(input: DeletePolicyTemplateRequest): DeletePolicyTemplateResponse {
        val op = SdkHttpOperation.build<DeletePolicyTemplateRequest, DeletePolicyTemplateResponse> {
            serializer = DeletePolicyTemplateOperationSerializer()
            deserializer = DeletePolicyTemplateOperationDeserializer()
            operationName = "DeletePolicyTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details about the specified identity source.
     */
    override suspend fun getIdentitySource(input: GetIdentitySourceRequest): GetIdentitySourceResponse {
        val op = SdkHttpOperation.build<GetIdentitySourceRequest, GetIdentitySourceResponse> {
            serializer = GetIdentitySourceOperationSerializer()
            deserializer = GetIdentitySourceOperationDeserializer()
            operationName = "GetIdentitySource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the specified policy.
     */
    override suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse {
        val op = SdkHttpOperation.build<GetPolicyRequest, GetPolicyResponse> {
            serializer = GetPolicyOperationSerializer()
            deserializer = GetPolicyOperationDeserializer()
            operationName = "GetPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves details about a policy store.
     */
    override suspend fun getPolicyStore(input: GetPolicyStoreRequest): GetPolicyStoreResponse {
        val op = SdkHttpOperation.build<GetPolicyStoreRequest, GetPolicyStoreResponse> {
            serializer = GetPolicyStoreOperationSerializer()
            deserializer = GetPolicyStoreOperationDeserializer()
            operationName = "GetPolicyStore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the details for the specified policy template in the specified policy store.
     */
    override suspend fun getPolicyTemplate(input: GetPolicyTemplateRequest): GetPolicyTemplateResponse {
        val op = SdkHttpOperation.build<GetPolicyTemplateRequest, GetPolicyTemplateResponse> {
            serializer = GetPolicyTemplateOperationSerializer()
            deserializer = GetPolicyTemplateOperationDeserializer()
            operationName = "GetPolicyTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve the details for the specified schema in the specified policy store.
     */
    override suspend fun getSchema(input: GetSchemaRequest): GetSchemaResponse {
        val op = SdkHttpOperation.build<GetSchemaRequest, GetSchemaResponse> {
            serializer = GetSchemaOperationSerializer()
            deserializer = GetSchemaOperationDeserializer()
            operationName = "GetSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Makes an authorization decision about a service request described in the parameters. The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
     */
    override suspend fun isAuthorized(input: IsAuthorizedRequest): IsAuthorizedResponse {
        val op = SdkHttpOperation.build<IsAuthorizedRequest, IsAuthorizedResponse> {
            serializer = IsAuthorizedOperationSerializer()
            deserializer = IsAuthorizedOperationDeserializer()
            operationName = "IsAuthorized"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Makes an authorization decision about a service request described in the parameters. The principal in this request comes from an external identity source in the form of an identity token formatted as a [JSON web token (JWT)](https://wikipedia.org/wiki/JSON_Web_Token). The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
     *
     * If you specify the `identityToken` parameter, then this operation derives the principal from that token. You must not also include that principal in the `entities` parameter or the operation fails and reports a conflict between the two entity sources.
     *
     * If you provide only an `accessToken`, then you can include the entity as part of the `entities` parameter to provide additional attributes.
     *
     * At this time, Verified Permissions accepts tokens from only Amazon Cognito.
     *
     * Verified Permissions validates each token that is specified in a request by checking its expiration date and its signature.
     *
     * If you delete a Amazon Cognito user pool or user, tokens from that deleted pool or that deleted user continue to be usable until they expire.
     */
    override suspend fun isAuthorizedWithToken(input: IsAuthorizedWithTokenRequest): IsAuthorizedWithTokenResponse {
        val op = SdkHttpOperation.build<IsAuthorizedWithTokenRequest, IsAuthorizedWithTokenResponse> {
            serializer = IsAuthorizedWithTokenOperationSerializer()
            deserializer = IsAuthorizedWithTokenOperationDeserializer()
            operationName = "IsAuthorizedWithToken"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all of the identity sources defined in the specified policy store.
     */
    override suspend fun listIdentitySources(input: ListIdentitySourcesRequest): ListIdentitySourcesResponse {
        val op = SdkHttpOperation.build<ListIdentitySourcesRequest, ListIdentitySourcesResponse> {
            serializer = ListIdentitySourcesOperationSerializer()
            deserializer = ListIdentitySourcesOperationDeserializer()
            operationName = "ListIdentitySources"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all policies stored in the specified policy store.
     */
    override suspend fun listPolicies(input: ListPoliciesRequest): ListPoliciesResponse {
        val op = SdkHttpOperation.build<ListPoliciesRequest, ListPoliciesResponse> {
            serializer = ListPoliciesOperationSerializer()
            deserializer = ListPoliciesOperationDeserializer()
            operationName = "ListPolicies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all policy stores in the calling Amazon Web Services account.
     */
    override suspend fun listPolicyStores(input: ListPolicyStoresRequest): ListPolicyStoresResponse {
        val op = SdkHttpOperation.build<ListPolicyStoresRequest, ListPolicyStoresResponse> {
            serializer = ListPolicyStoresOperationSerializer()
            deserializer = ListPolicyStoresOperationDeserializer()
            operationName = "ListPolicyStores"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all policy templates in the specified policy store.
     */
    override suspend fun listPolicyTemplates(input: ListPolicyTemplatesRequest): ListPolicyTemplatesResponse {
        val op = SdkHttpOperation.build<ListPolicyTemplatesRequest, ListPolicyTemplatesResponse> {
            serializer = ListPolicyTemplatesOperationSerializer()
            deserializer = ListPolicyTemplatesOperationDeserializer()
            operationName = "ListPolicyTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates the policy schema in the specified policy store. The schema is used to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun putSchema(input: PutSchemaRequest): PutSchemaResponse {
        val op = SdkHttpOperation.build<PutSchemaRequest, PutSchemaResponse> {
            serializer = PutSchemaOperationSerializer()
            deserializer = PutSchemaOperationDeserializer()
            operationName = "PutSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified identity source to use a new identity provider (IdP) source, or to change the mapping of identities from the IdP to a different principal entity type.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun updateIdentitySource(input: UpdateIdentitySourceRequest): UpdateIdentitySourceResponse {
        val op = SdkHttpOperation.build<UpdateIdentitySourceRequest, UpdateIdentitySourceResponse> {
            serializer = UpdateIdentitySourceOperationSerializer()
            deserializer = UpdateIdentitySourceOperationDeserializer()
            operationName = "UpdateIdentitySource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a Cedar static policy in the specified policy store. You can change only certain elements of the [UpdatePolicyDefinition](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyInput.html#amazonverifiedpermissions-UpdatePolicy-request-UpdatePolicyDefinition) parameter. You can directly update only static policies. To change a template-linked policy, you must update the template instead, using [UpdatePolicyTemplate](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html).
     *
     * + If policy validation is enabled in the policy store, then updating a static policy causes Verified Permissions to validate the policy against the schema in the policy store. If the updated static policy doesn't pass validation, the operation fails and the update isn't stored.
     * + When you edit a static policy, you can change only certain elements of a static policy:
     *    + The action referenced by the policy.
     *    + A condition clause, such as when and unless.
     * You can't change these elements of a static policy:
     *    + Changing a policy from a static policy to a template-linked policy.
     *    + Changing the effect of a static policy from permit or forbid.
     *    + The principal referenced by a static policy.
     *    + The resource referenced by a static policy.
     * + To update a template-linked policy, you must update the template instead.
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun updatePolicy(input: UpdatePolicyRequest): UpdatePolicyResponse {
        val op = SdkHttpOperation.build<UpdatePolicyRequest, UpdatePolicyResponse> {
            serializer = UpdatePolicyOperationSerializer()
            deserializer = UpdatePolicyOperationDeserializer()
            operationName = "UpdatePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the validation setting for a policy store.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun updatePolicyStore(input: UpdatePolicyStoreRequest): UpdatePolicyStoreResponse {
        val op = SdkHttpOperation.build<UpdatePolicyStoreRequest, UpdatePolicyStoreResponse> {
            serializer = UpdatePolicyStoreOperationSerializer()
            deserializer = UpdatePolicyStoreOperationDeserializer()
            operationName = "UpdatePolicyStore"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified policy template. You can update only the description and the some elements of the [policyBody](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html#amazonverifiedpermissions-UpdatePolicyTemplate-request-policyBody).
     *
     * Changes you make to the policy template content are immediately (within the constraints of eventual consistency) reflected in authorization decisions that involve all template-linked policies instantiated from this template.
     *
     * Verified Permissions is *[eventually consistent](https://wikipedia.org/wiki/Eventual_consistency)*. It can take a few seconds for a new or changed element to propagate through the service and be visible in the results of other Verified Permissions operations.
     */
    override suspend fun updatePolicyTemplate(input: UpdatePolicyTemplateRequest): UpdatePolicyTemplateResponse {
        val op = SdkHttpOperation.build<UpdatePolicyTemplateRequest, UpdatePolicyTemplateResponse> {
            serializer = UpdatePolicyTemplateOperationSerializer()
            deserializer = UpdatePolicyTemplateOperationDeserializer()
            operationName = "UpdatePolicyTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("VerifiedPermissions", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "verifiedpermissions")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
