// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a policy.
 *
 * This data type is used as a response parameter for the [ListPolicies](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html) operation.
 */
public class PolicyItem private constructor(builder: Builder) {
    /**
     * The date and time the policy was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdDate) { "A non-null value must be provided for createdDate" }
    /**
     * The policy definition of an item in the list of policies returned.
     */
    public val definition: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinitionItem? = builder.definition
    /**
     * The date and time the policy was most recently updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedDate) { "A non-null value must be provided for lastUpdatedDate" }
    /**
     * The identifier of the policy you want information about.
     */
    public val policyId: kotlin.String = requireNotNull(builder.policyId) { "A non-null value must be provided for policyId" }
    /**
     * The identifier of the PolicyStore where the policy you want information about is stored.
     */
    public val policyStoreId: kotlin.String = requireNotNull(builder.policyStoreId) { "A non-null value must be provided for policyStoreId" }
    /**
     * The type of the policy. This is one of the following values:
     * + `static`
     * + `templateLinked`
     */
    public val policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType = requireNotNull(builder.policyType) { "A non-null value must be provided for policyType" }
    /**
     * The principal associated with the policy.
     */
    public val principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.principal
    /**
     * The resource associated with the policy.
     */
    public val resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyItem(")
        append("createdDate=$createdDate,")
        append("definition=$definition,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("policyId=$policyId,")
        append("policyStoreId=$policyStoreId,")
        append("policyType=$policyType,")
        append("principal=$principal,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate.hashCode()
        result = 31 * result + (definition?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate.hashCode())
        result = 31 * result + (policyId.hashCode())
        result = 31 * result + (policyStoreId.hashCode())
        result = 31 * result + (policyType.hashCode())
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyItem

        if (createdDate != other.createdDate) return false
        if (definition != other.definition) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (policyId != other.policyId) return false
        if (policyStoreId != other.policyStoreId) return false
        if (policyType != other.policyType) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time the policy was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The policy definition of an item in the list of policies returned.
         */
        public var definition: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyDefinitionItem? = null
        /**
         * The date and time the policy was most recently updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the policy you want information about.
         */
        public var policyId: kotlin.String? = null
        /**
         * The identifier of the PolicyStore where the policy you want information about is stored.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * The type of the policy. This is one of the following values:
         * + `static`
         * + `templateLinked`
         */
        public var policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType? = null
        /**
         * The principal associated with the policy.
         */
        public var principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null
        /**
         * The resource associated with the policy.
         */
        public var resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyItem) : this() {
            this.createdDate = x.createdDate
            this.definition = x.definition
            this.lastUpdatedDate = x.lastUpdatedDate
            this.policyId = x.policyId
            this.policyStoreId = x.policyStoreId
            this.policyType = x.policyType
            this.principal = x.principal
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyItem = PolicyItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun principal(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.principal = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.verifiedpermissions.model.EntityIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdDate == null) createdDate = Instant.fromEpochSeconds(0)
            if (lastUpdatedDate == null) lastUpdatedDate = Instant.fromEpochSeconds(0)
            if (policyId == null) policyId = ""
            if (policyStoreId == null) policyStoreId = ""
            if (policyType == null) policyType = PolicyType.SdkUnknown("no value provided")
            return this
        }
    }
}
