// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListPoliciesRequest private constructor(builder: Builder) {
    /**
     * Specifies a filter that limits the response to only policies that match the specified criteria. For example, you list only the policies that reference a specified principal.
     */
    public val filter: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter? = builder.filter
    /**
     * Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the `NextToken` response element is returned with a value (not null). Include the specified value as the `NextToken` request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check `NextToken` after every operation to ensure that you receive all of the results.
     *
     * If you do not specify this parameter, the operation defaults to 10 policies per response. You can specify a maximum of 50 policies per response.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Specifies that you want to receive the next page of results. Valid only if you received a `NextToken` response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's `NextToken` response to request the next page of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies the ID of the policy store you want to list policies from.
     */
    public val policyStoreId: kotlin.String? = builder.policyStoreId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPoliciesRequest(")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("policyStoreId=$policyStoreId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (policyStoreId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPoliciesRequest

        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (policyStoreId != other.policyStoreId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a filter that limits the response to only policies that match the specified criteria. For example, you list only the policies that reference a specified principal.
         */
        public var filter: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter? = null
        /**
         * Specifies the total number of results that you want included in each response. If additional items exist beyond the number you specify, the `NextToken` response element is returned with a value (not null). Include the specified value as the `NextToken` request parameter in the next call to the operation to get the next set of results. Note that the service might return fewer results than the maximum even when there are more results available. You should check `NextToken` after every operation to ensure that you receive all of the results.
         *
         * If you do not specify this parameter, the operation defaults to 10 policies per response. You can specify a maximum of 50 policies per response.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Specifies that you want to receive the next page of results. Valid only if you received a `NextToken` response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call's `NextToken` response to request the next page of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specifies the ID of the policy store you want to list policies from.
         */
        public var policyStoreId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesRequest) : this() {
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.policyStoreId = x.policyStoreId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.ListPoliciesRequest = ListPoliciesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
