// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration for an identity source that represents a connection to an Amazon Cognito user pool used as an identity provider for Verified Permissions.
 *
 * This data type is used as a field that is part of the [ConfigurationItem](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ConfigurationItem.html) structure that is part of the response to [ListIdentitySources](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentitySources.html).
 *
 * Example:`"CognitoUserPoolConfiguration":{"UserPoolArn":"arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","ClientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}`
 */
public class CognitoUserPoolConfigurationItem private constructor(builder: Builder) {
    /**
     * The unique application client IDs that are associated with the specified Amazon Cognito user pool.
     *
     * Example: `"clientIds": ["&amp;ExampleCogClientId;"]`
     */
    public val clientIds: List<String> = requireNotNull(builder.clientIds) { "A non-null value must be provided for clientIds" }
    /**
     * The configuration of the user groups from an Amazon Cognito user pool identity source.
     */
    public val groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfigurationItem? = builder.groupConfiguration
    /**
     * The OpenID Connect (OIDC) `issuer` ID of the Amazon Cognito user pool that contains the identities to be authorized.
     *
     * Example: `"issuer": "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"`
     */
    public val issuer: kotlin.String = requireNotNull(builder.issuer) { "A non-null value must be provided for issuer" }
    /**
     * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon Cognito user pool that contains the identities to be authorized.
     *
     * Example: `"userPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"`
     */
    public val userPoolArn: kotlin.String = requireNotNull(builder.userPoolArn) { "A non-null value must be provided for userPoolArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfigurationItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoUserPoolConfigurationItem(")
        append("clientIds=$clientIds,")
        append("groupConfiguration=$groupConfiguration,")
        append("issuer=$issuer,")
        append("userPoolArn=$userPoolArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIds.hashCode()
        result = 31 * result + (groupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (issuer.hashCode())
        result = 31 * result + (userPoolArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoUserPoolConfigurationItem

        if (clientIds != other.clientIds) return false
        if (groupConfiguration != other.groupConfiguration) return false
        if (issuer != other.issuer) return false
        if (userPoolArn != other.userPoolArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfigurationItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique application client IDs that are associated with the specified Amazon Cognito user pool.
         *
         * Example: `"clientIds": ["&amp;ExampleCogClientId;"]`
         */
        public var clientIds: List<String>? = null
        /**
         * The configuration of the user groups from an Amazon Cognito user pool identity source.
         */
        public var groupConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfigurationItem? = null
        /**
         * The OpenID Connect (OIDC) `issuer` ID of the Amazon Cognito user pool that contains the identities to be authorized.
         *
         * Example: `"issuer": "https://cognito-idp.us-east-1.amazonaws.com/us-east-1_1a2b3c4d5"`
         */
        public var issuer: kotlin.String? = null
        /**
         * The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Amazon Cognito user pool that contains the identities to be authorized.
         *
         * Example: `"userPoolArn": "arn:aws:cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5"`
         */
        public var userPoolArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfigurationItem) : this() {
            this.clientIds = x.clientIds
            this.groupConfiguration = x.groupConfiguration
            this.issuer = x.issuer
            this.userPoolArn = x.userPoolArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoUserPoolConfigurationItem = CognitoUserPoolConfigurationItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfigurationItem] inside the given [block]
         */
        public fun groupConfiguration(block: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfigurationItem.Builder.() -> kotlin.Unit) {
            this.groupConfiguration = aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfigurationItem.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (clientIds == null) clientIds = emptyList()
            if (issuer == null) issuer = ""
            if (userPoolArn == null) userPoolArn = ""
            return this
        }
    }
}
