// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of user groups and entities from an Amazon Cognito user pool identity source.
 *
 * This data type is part of a [CognitoUserPoolConfiguration](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CognitoUserPoolConfiguration.html) structure and is a request parameter in [CreateIdentitySource](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html).
 */
public class CognitoGroupConfiguration private constructor(builder: Builder) {
    /**
     * The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
     */
    public val groupEntityType: kotlin.String = requireNotNull(builder.groupEntityType) { "A non-null value must be provided for groupEntityType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoGroupConfiguration(")
        append("groupEntityType=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupEntityType.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CognitoGroupConfiguration

        if (groupEntityType != other.groupEntityType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the schema entity type that's mapped to the user pool group. Defaults to `AWS::CognitoGroup`.
         */
        public var groupEntityType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration) : this() {
            this.groupEntityType = x.groupEntityType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.CognitoGroupConfiguration = CognitoGroupConfiguration(this)

        internal fun correctErrors(): Builder {
            if (groupEntityType == null) groupEntityType = ""
            return this
        }
    }
}
