// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



public class UpdateIdentitySourceRequest private constructor(builder: Builder) {
    /**
     * Specifies the ID of the identity source that you want to update.
     */
    public val identitySourceId: kotlin.String? = builder.identitySourceId
    /**
     * Specifies the ID of the policy store that contains the identity source that you want to update.
     */
    public val policyStoreId: kotlin.String? = builder.policyStoreId
    /**
     * Specifies the data type of principals generated for identities authenticated by the identity source.
     */
    public val principalEntityType: kotlin.String? = builder.principalEntityType
    /**
     * Specifies the details required to communicate with the identity provider (IdP) associated with this identity source.
     *
     * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
     *
     * You must specify a `userPoolArn`, and optionally, a `ClientId`.
     */
    public val updateConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateConfiguration? = builder.updateConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateIdentitySourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIdentitySourceRequest(")
        append("identitySourceId=$identitySourceId,")
        append("policyStoreId=$policyStoreId,")
        append("principalEntityType=*** Sensitive Data Redacted ***,")
        append("updateConfiguration=$updateConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identitySourceId?.hashCode() ?: 0
        result = 31 * result + (policyStoreId?.hashCode() ?: 0)
        result = 31 * result + (principalEntityType?.hashCode() ?: 0)
        result = 31 * result + (updateConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIdentitySourceRequest

        if (identitySourceId != other.identitySourceId) return false
        if (policyStoreId != other.policyStoreId) return false
        if (principalEntityType != other.principalEntityType) return false
        if (updateConfiguration != other.updateConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateIdentitySourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the ID of the identity source that you want to update.
         */
        public var identitySourceId: kotlin.String? = null
        /**
         * Specifies the ID of the policy store that contains the identity source that you want to update.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * Specifies the data type of principals generated for identities authenticated by the identity source.
         */
        public var principalEntityType: kotlin.String? = null
        /**
         * Specifies the details required to communicate with the identity provider (IdP) associated with this identity source.
         *
         * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
         *
         * You must specify a `userPoolArn`, and optionally, a `ClientId`.
         */
        public var updateConfiguration: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.UpdateIdentitySourceRequest) : this() {
            this.identitySourceId = x.identitySourceId
            this.policyStoreId = x.policyStoreId
            this.principalEntityType = x.principalEntityType
            this.updateConfiguration = x.updateConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.UpdateIdentitySourceRequest = UpdateIdentitySourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
