// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * Contains information about a filter to refine policies returned in a query.
 *
 * This data type is used as a response parameter for the [ListPolicies](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListPolicies.html) operation.
 */
public class PolicyFilter private constructor(builder: Builder) {
    /**
     * Filters the output to only template-linked policies that were instantiated from the specified policy template.
     */
    public val policyTemplateId: kotlin.String? = builder.policyTemplateId
    /**
     * Filters the output to only policies of the specified type.
     */
    public val policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType? = builder.policyType
    /**
     * Filters the output to only policies that reference the specified principal.
     */
    public val principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityReference? = builder.principal
    /**
     * Filters the output to only policies that reference the specified resource.
     */
    public val resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityReference? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyFilter(")
        append("policyTemplateId=$policyTemplateId,")
        append("policyType=$policyType,")
        append("principal=$principal,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = policyTemplateId?.hashCode() ?: 0
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (principal?.hashCode() ?: 0)
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyFilter

        if (policyTemplateId != other.policyTemplateId) return false
        if (policyType != other.policyType) return false
        if (principal != other.principal) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters the output to only template-linked policies that were instantiated from the specified policy template.
         */
        public var policyTemplateId: kotlin.String? = null
        /**
         * Filters the output to only policies of the specified type.
         */
        public var policyType: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyType? = null
        /**
         * Filters the output to only policies that reference the specified principal.
         */
        public var principal: aws.sdk.kotlin.services.verifiedpermissions.model.EntityReference? = null
        /**
         * Filters the output to only policies that reference the specified resource.
         */
        public var resource: aws.sdk.kotlin.services.verifiedpermissions.model.EntityReference? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter) : this() {
            this.policyTemplateId = x.policyTemplateId
            this.policyType = x.policyType
            this.principal = x.principal
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.PolicyFilter = PolicyFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
