// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



public class BatchIsAuthorizedWithTokenRequest private constructor(builder: Builder) {
    /**
     * Specifies an access token for the principal that you want to authorize in each request. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
     *
     * Must be an access token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `access`.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * Specifies the list of resources and their associated attributes that Verified Permissions can examine when evaluating the policies.
     *
     * You can't include principals in this parameter, only resource and action entities. This parameter can't include any entities of a type that matches the user or group entity types that you defined in your identity source.
     * + The `BatchIsAuthorizedWithToken` operation takes principal attributes from ***only*** the `identityToken` or `accessToken` passed to the operation.
     * + For action entities, you can include only their `Identifier` and `EntityType`.
     */
    public val entities: aws.sdk.kotlin.services.verifiedpermissions.model.EntitiesDefinition? = builder.entities
    /**
     * Specifies an identity (ID) token for the principal that you want to authorize in each request. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
     *
     * Must be an ID token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `id`.
     */
    public val identityToken: kotlin.String? = builder.identityToken
    /**
     * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization decision for the input.
     */
    public val policyStoreId: kotlin.String? = builder.policyStoreId
    /**
     * An array of up to 30 requests that you want Verified Permissions to evaluate.
     */
    public val requests: List<BatchIsAuthorizedWithTokenInputItem>? = builder.requests

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchIsAuthorizedWithTokenRequest(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("entities=$entities,")
        append("identityToken=*** Sensitive Data Redacted ***,")
        append("policyStoreId=$policyStoreId,")
        append("requests=$requests")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (entities?.hashCode() ?: 0)
        result = 31 * result + (identityToken?.hashCode() ?: 0)
        result = 31 * result + (policyStoreId?.hashCode() ?: 0)
        result = 31 * result + (requests?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchIsAuthorizedWithTokenRequest

        if (accessToken != other.accessToken) return false
        if (entities != other.entities) return false
        if (identityToken != other.identityToken) return false
        if (policyStoreId != other.policyStoreId) return false
        if (requests != other.requests) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies an access token for the principal that you want to authorize in each request. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
         *
         * Must be an access token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `access`.
         */
        public var accessToken: kotlin.String? = null
        /**
         * Specifies the list of resources and their associated attributes that Verified Permissions can examine when evaluating the policies.
         *
         * You can't include principals in this parameter, only resource and action entities. This parameter can't include any entities of a type that matches the user or group entity types that you defined in your identity source.
         * + The `BatchIsAuthorizedWithToken` operation takes principal attributes from ***only*** the `identityToken` or `accessToken` passed to the operation.
         * + For action entities, you can include only their `Identifier` and `EntityType`.
         */
        public var entities: aws.sdk.kotlin.services.verifiedpermissions.model.EntitiesDefinition? = null
        /**
         * Specifies an identity (ID) token for the principal that you want to authorize in each request. This token is provided to you by the identity provider (IdP) associated with the specified identity source. You must specify either an `accessToken`, an `identityToken`, or both.
         *
         * Must be an ID token. Verified Permissions returns an error if the `token_use` claim in the submitted token isn't `id`.
         */
        public var identityToken: kotlin.String? = null
        /**
         * Specifies the ID of the policy store. Policies in this policy store will be used to make an authorization decision for the input.
         */
        public var policyStoreId: kotlin.String? = null
        /**
         * An array of up to 30 requests that you want Verified Permissions to evaluate.
         */
        public var requests: List<BatchIsAuthorizedWithTokenInputItem>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenRequest) : this() {
            this.accessToken = x.accessToken
            this.entities = x.entities
            this.identityToken = x.identityToken
            this.policyStoreId = x.policyStoreId
            this.requests = x.requests
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenRequest = BatchIsAuthorizedWithTokenRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
