// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.verifiedpermissions.model



/**
 * The decision, based on policy evaluation, from an individual authorization request in a `BatchIsAuthorizedWithToken` API request.
 */
public class BatchIsAuthorizedWithTokenOutputItem private constructor(builder: Builder) {
    /**
     * An authorization decision that indicates if the authorization request should be allowed or denied.
     */
    public val decision: aws.sdk.kotlin.services.verifiedpermissions.model.Decision = requireNotNull(builder.decision) { "A non-null value must be provided for decision" }
    /**
     * The list of determining policies used to make the authorization decision. For example, if there are two matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the determining policy. In the case of multiple matching permit policies then there would be multiple determining policies. In the case that no policies match, and hence the response is DENY, there would be no determining policies.
     */
    public val determiningPolicies: List<DeterminingPolicyItem> = requireNotNull(builder.determiningPolicies) { "A non-null value must be provided for determiningPolicies" }
    /**
     * Errors that occurred while making an authorization decision. For example, a policy might reference an entity or attribute that doesn't exist in the request.
     */
    public val errors: List<EvaluationErrorItem> = requireNotNull(builder.errors) { "A non-null value must be provided for errors" }
    /**
     * The authorization request that initiated the decision.
     */
    public val request: aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputItem? = builder.request

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenOutputItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchIsAuthorizedWithTokenOutputItem(")
        append("decision=$decision,")
        append("determiningPolicies=$determiningPolicies,")
        append("errors=$errors,")
        append("request=$request")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = decision.hashCode()
        result = 31 * result + (determiningPolicies.hashCode())
        result = 31 * result + (errors.hashCode())
        result = 31 * result + (request?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchIsAuthorizedWithTokenOutputItem

        if (decision != other.decision) return false
        if (determiningPolicies != other.determiningPolicies) return false
        if (errors != other.errors) return false
        if (request != other.request) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenOutputItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An authorization decision that indicates if the authorization request should be allowed or denied.
         */
        public var decision: aws.sdk.kotlin.services.verifiedpermissions.model.Decision? = null
        /**
         * The list of determining policies used to make the authorization decision. For example, if there are two matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the determining policy. In the case of multiple matching permit policies then there would be multiple determining policies. In the case that no policies match, and hence the response is DENY, there would be no determining policies.
         */
        public var determiningPolicies: List<DeterminingPolicyItem>? = null
        /**
         * Errors that occurred while making an authorization decision. For example, a policy might reference an entity or attribute that doesn't exist in the request.
         */
        public var errors: List<EvaluationErrorItem>? = null
        /**
         * The authorization request that initiated the decision.
         */
        public var request: aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputItem? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenOutputItem) : this() {
            this.decision = x.decision
            this.determiningPolicies = x.determiningPolicies
            this.errors = x.errors
            this.request = x.request
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenOutputItem = BatchIsAuthorizedWithTokenOutputItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputItem] inside the given [block]
         */
        public fun request(block: aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputItem.Builder.() -> kotlin.Unit) {
            this.request = aws.sdk.kotlin.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputItem.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (decision == null) decision = Decision.SdkUnknown("no value provided")
            if (determiningPolicies == null) determiningPolicies = emptyList()
            if (errors == null) errors = emptyList()
            return this
        }
    }
}
