// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.transform

import aws.sdk.kotlin.runtime.protocol.eventstream.HeaderValue
import aws.sdk.kotlin.runtime.protocol.eventstream.Message
import aws.sdk.kotlin.runtime.protocol.eventstream.asEventStreamHttpBody
import aws.sdk.kotlin.runtime.protocol.eventstream.buildMessage
import aws.sdk.kotlin.runtime.protocol.eventstream.encode
import aws.sdk.kotlin.runtime.protocol.eventstream.newEventStreamSigningConfig
import aws.sdk.kotlin.runtime.protocol.eventstream.sign
import aws.sdk.kotlin.services.transcribestreaming.model.AudioStream
import aws.sdk.kotlin.services.transcribestreaming.model.ContentIdentificationType
import aws.sdk.kotlin.services.transcribestreaming.model.ContentRedactionType
import aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode
import aws.sdk.kotlin.services.transcribestreaming.model.MediaEncoding
import aws.sdk.kotlin.services.transcribestreaming.model.PartialResultsStability
import aws.sdk.kotlin.services.transcribestreaming.model.StartStreamTranscriptionRequest
import aws.sdk.kotlin.services.transcribestreaming.model.VocabularyFilterMethod
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class StartStreamTranscriptionOperationSerializer: HttpSerialize<StartStreamTranscriptionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartStreamTranscriptionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/stream-transcription"
        }

        builder.headers {
            if (input.contentIdentificationType != null) append("x-amzn-transcribe-content-identification-type", input.contentIdentificationType.value)
            if (input.contentRedactionType != null) append("x-amzn-transcribe-content-redaction-type", input.contentRedactionType.value)
            if (input.enableChannelIdentification != false) append("x-amzn-transcribe-enable-channel-identification", "${input.enableChannelIdentification}")
            if (input.enablePartialResultsStabilization != false) append("x-amzn-transcribe-enable-partial-results-stabilization", "${input.enablePartialResultsStabilization}")
            if (input.identifyLanguage != false) append("x-amzn-transcribe-identify-language", "${input.identifyLanguage}")
            if (input.languageCode != null) append("x-amzn-transcribe-language-code", input.languageCode.value)
            if (input.languageModelName?.isNotEmpty() == true) append("x-amzn-transcribe-language-model-name", input.languageModelName)
            if (input.languageOptions?.isNotEmpty() == true) append("x-amzn-transcribe-language-options", input.languageOptions)
            if (input.mediaEncoding != null) append("x-amzn-transcribe-media-encoding", input.mediaEncoding.value)
            if (input.mediaSampleRateHertz != null) append("x-amzn-transcribe-sample-rate", "${input.mediaSampleRateHertz}")
            if (input.numberOfChannels != null) append("x-amzn-transcribe-number-of-channels", "${input.numberOfChannels}")
            if (input.partialResultsStability != null) append("x-amzn-transcribe-partial-results-stability", input.partialResultsStability.value)
            if (input.piiEntityTypes?.isNotEmpty() == true) append("x-amzn-transcribe-pii-entity-types", input.piiEntityTypes)
            if (input.preferredLanguage != null) append("x-amzn-transcribe-preferred-language", input.preferredLanguage.value)
            if (input.sessionId?.isNotEmpty() == true) append("x-amzn-transcribe-session-id", input.sessionId)
            if (input.showSpeakerLabel != false) append("x-amzn-transcribe-show-speaker-label", "${input.showSpeakerLabel}")
            if (input.vocabularyFilterMethod != null) append("x-amzn-transcribe-vocabulary-filter-method", input.vocabularyFilterMethod.value)
            if (input.vocabularyFilterName?.isNotEmpty() == true) append("x-amzn-transcribe-vocabulary-filter-name", input.vocabularyFilterName)
            if (input.vocabularyFilterNames?.isNotEmpty() == true) append("x-amzn-transcribe-vocabulary-filter-names", input.vocabularyFilterNames)
            if (input.vocabularyName?.isNotEmpty() == true) append("x-amzn-transcribe-vocabulary-name", input.vocabularyName)
            if (input.vocabularyNames?.isNotEmpty() == true) append("x-amzn-transcribe-vocabulary-names", input.vocabularyNames)
        }

        builder.body = serializeStartStreamTranscriptionOperationBody(context, input)
        return builder
    }
}

internal suspend fun serializeStartStreamTranscriptionOperationBody(context: ExecutionContext, input: StartStreamTranscriptionRequest): HttpBody {
    val stream = input.audioStream ?: return HttpBody.Empty
    val signingConfig = context.newEventStreamSigningConfig()
    context[AwsSigningAttributes.HashSpecification] = HashSpecification.EmptyBody
    val messages = stream
        .map(::encodeStartStreamTranscriptionAudioStreamEventMessage)
        .sign(context, signingConfig)
        .encode()

    return messages.asEventStreamHttpBody(context)
}

private fun encodeStartStreamTranscriptionAudioStreamEventMessage(input: AudioStream): Message = buildMessage {
    addHeader(":message-type", HeaderValue.String("event"))
    when(input) {
        is AudioStream.AudioEvent -> {
            addHeader(":event-type", HeaderValue.String("AudioEvent"))
            addHeader(":content-type", HeaderValue.String("application/octet-stream"))
            payload = input.value.audioChunk
        }
        is AudioStream.SdkUnknown -> error("cannot serialize the unknown event type!")
    }
}
