// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.transform

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.eventstream.MessageType
import aws.sdk.kotlin.runtime.protocol.eventstream.decodeFrames
import aws.sdk.kotlin.runtime.protocol.eventstream.type
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transcribestreaming.model.ContentIdentificationType
import aws.sdk.kotlin.services.transcribestreaming.model.ContentRedactionType
import aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode
import aws.sdk.kotlin.services.transcribestreaming.model.MediaEncoding
import aws.sdk.kotlin.services.transcribestreaming.model.PartialResultsStability
import aws.sdk.kotlin.services.transcribestreaming.model.StartStreamTranscriptionResponse
import aws.sdk.kotlin.services.transcribestreaming.model.TranscribeStreamingException
import aws.sdk.kotlin.services.transcribestreaming.model.TranscriptResultStream
import aws.sdk.kotlin.services.transcribestreaming.model.VocabularyFilterMethod
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class StartStreamTranscriptionOperationDeserializer: HttpDeserialize<StartStreamTranscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartStreamTranscriptionResponse {
        if (!response.status.isSuccess()) {
            throwStartStreamTranscriptionError(context, response)
        }
        val builder = StartStreamTranscriptionResponse.Builder()

        builder.contentIdentificationType = response.headers["x-amzn-transcribe-content-identification-type"]?.let { ContentIdentificationType.fromValue(it) }
        builder.contentRedactionType = response.headers["x-amzn-transcribe-content-redaction-type"]?.let { ContentRedactionType.fromValue(it) }
        builder.enableChannelIdentification = response.headers["x-amzn-transcribe-enable-channel-identification"]?.toBoolean() ?: false
        builder.enablePartialResultsStabilization = response.headers["x-amzn-transcribe-enable-partial-results-stabilization"]?.toBoolean() ?: false
        builder.identifyLanguage = response.headers["x-amzn-transcribe-identify-language"]?.toBoolean() ?: false
        builder.languageCode = response.headers["x-amzn-transcribe-language-code"]?.let { LanguageCode.fromValue(it) }
        builder.languageModelName = response.headers["x-amzn-transcribe-language-model-name"]
        builder.languageOptions = response.headers["x-amzn-transcribe-language-options"]
        builder.mediaEncoding = response.headers["x-amzn-transcribe-media-encoding"]?.let { MediaEncoding.fromValue(it) }
        builder.mediaSampleRateHertz = response.headers["x-amzn-transcribe-sample-rate"]?.toInt()
        builder.numberOfChannels = response.headers["x-amzn-transcribe-number-of-channels"]?.toInt()
        builder.partialResultsStability = response.headers["x-amzn-transcribe-partial-results-stability"]?.let { PartialResultsStability.fromValue(it) }
        builder.piiEntityTypes = response.headers["x-amzn-transcribe-pii-entity-types"]
        builder.preferredLanguage = response.headers["x-amzn-transcribe-preferred-language"]?.let { LanguageCode.fromValue(it) }
        builder.requestId = response.headers["x-amzn-request-id"]
        builder.sessionId = response.headers["x-amzn-transcribe-session-id"]
        builder.showSpeakerLabel = response.headers["x-amzn-transcribe-show-speaker-label"]?.toBoolean() ?: false
        builder.vocabularyFilterMethod = response.headers["x-amzn-transcribe-vocabulary-filter-method"]?.let { VocabularyFilterMethod.fromValue(it) }
        builder.vocabularyFilterName = response.headers["x-amzn-transcribe-vocabulary-filter-name"]
        builder.vocabularyFilterNames = response.headers["x-amzn-transcribe-vocabulary-filter-names"]
        builder.vocabularyName = response.headers["x-amzn-transcribe-vocabulary-name"]
        builder.vocabularyNames = response.headers["x-amzn-transcribe-vocabulary-names"]

        deserializeStartStreamTranscriptionOperationBody(builder, response.body)
        return builder.build()
    }
}

private suspend fun throwStartStreamTranscriptionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeStreamingException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeStreamingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeStartStreamTranscriptionOperationBody(builder: StartStreamTranscriptionResponse.Builder, body: HttpBody) {
    val chan = body.toSdkByteReadChannel() ?: return
    val events = decodeFrames(chan)
        .map { message ->
            when(val mt = message.type()) {
                is MessageType.Event -> when(mt.shapeType) {
                    "TranscriptEvent" -> {
                        val e = deserializeTranscriptEventPayload(message.payload)
                        TranscriptResultStream.TranscriptEvent(e)
                    }
                    else -> TranscriptResultStream.SdkUnknown
                }
                is MessageType.Exception -> when(mt.shapeType){
                    "BadRequestException" -> {
                        val err = deserializeBadRequestExceptionPayload(message.payload)
                        throw err
                    }
                    "LimitExceededException" -> {
                        val err = deserializeLimitExceededExceptionPayload(message.payload)
                        throw err
                    }
                    "InternalFailureException" -> {
                        val err = deserializeInternalFailureExceptionPayload(message.payload)
                        throw err
                    }
                    "ConflictException" -> {
                        val err = deserializeConflictExceptionPayload(message.payload)
                        throw err
                    }
                    "ServiceUnavailableException" -> {
                        val err = deserializeServiceUnavailableExceptionPayload(message.payload)
                        throw err
                    }
                    else -> throw TranscribeStreamingException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw TranscribeStreamingException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }
    builder.transcriptResultStream = events
}
