// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.transform

import aws.sdk.kotlin.runtime.protocol.eventstream.HeaderValue
import aws.sdk.kotlin.runtime.protocol.eventstream.Message
import aws.sdk.kotlin.runtime.protocol.eventstream.asEventStreamHttpBody
import aws.sdk.kotlin.runtime.protocol.eventstream.buildMessage
import aws.sdk.kotlin.runtime.protocol.eventstream.encode
import aws.sdk.kotlin.runtime.protocol.eventstream.newEventStreamSigningConfig
import aws.sdk.kotlin.runtime.protocol.eventstream.sign
import aws.sdk.kotlin.services.transcribestreaming.model.AudioStream
import aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode
import aws.sdk.kotlin.services.transcribestreaming.model.MediaEncoding
import aws.sdk.kotlin.services.transcribestreaming.model.MedicalContentIdentificationType
import aws.sdk.kotlin.services.transcribestreaming.model.Specialty
import aws.sdk.kotlin.services.transcribestreaming.model.StartMedicalStreamTranscriptionRequest
import aws.sdk.kotlin.services.transcribestreaming.model.Type
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class StartMedicalStreamTranscriptionOperationSerializer: HttpSerialize<StartMedicalStreamTranscriptionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartMedicalStreamTranscriptionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/medical-stream-transcription"
        }

        builder.headers {
            if (input.contentIdentificationType != null) append("x-amzn-transcribe-content-identification-type", input.contentIdentificationType.value)
            if (input.enableChannelIdentification != false) append("x-amzn-transcribe-enable-channel-identification", "${input.enableChannelIdentification}")
            if (input.languageCode != null) append("x-amzn-transcribe-language-code", input.languageCode.value)
            if (input.mediaEncoding != null) append("x-amzn-transcribe-media-encoding", input.mediaEncoding.value)
            if (input.mediaSampleRateHertz != null) append("x-amzn-transcribe-sample-rate", "${input.mediaSampleRateHertz}")
            if (input.numberOfChannels != null) append("x-amzn-transcribe-number-of-channels", "${input.numberOfChannels}")
            if (input.sessionId?.isNotEmpty() == true) append("x-amzn-transcribe-session-id", input.sessionId)
            if (input.showSpeakerLabel != false) append("x-amzn-transcribe-show-speaker-label", "${input.showSpeakerLabel}")
            if (input.specialty != null) append("x-amzn-transcribe-specialty", input.specialty.value)
            if (input.type != null) append("x-amzn-transcribe-type", input.type.value)
            if (input.vocabularyName?.isNotEmpty() == true) append("x-amzn-transcribe-vocabulary-name", input.vocabularyName)
        }

        builder.body = serializeStartMedicalStreamTranscriptionOperationBody(context, input)
        return builder
    }
}

internal suspend fun serializeStartMedicalStreamTranscriptionOperationBody(context: ExecutionContext, input: StartMedicalStreamTranscriptionRequest): HttpBody {
    val stream = input.audioStream ?: return HttpBody.Empty
    val signingConfig = context.newEventStreamSigningConfig()
    context[AwsSigningAttributes.HashSpecification] = HashSpecification.EmptyBody
    val messages = stream
        .map(::encodeStartMedicalStreamTranscriptionAudioStreamEventMessage)
        .sign(context, signingConfig)
        .encode()

    return messages.asEventStreamHttpBody(context)
}

private fun encodeStartMedicalStreamTranscriptionAudioStreamEventMessage(input: AudioStream): Message = buildMessage {
    addHeader(":message-type", HeaderValue.String("event"))
    when(input) {
        is AudioStream.AudioEvent -> {
            addHeader(":event-type", HeaderValue.String("AudioEvent"))
            addHeader(":content-type", HeaderValue.String("application/octet-stream"))
            payload = input.value.audioChunk
        }
        is AudioStream.SdkUnknown -> error("cannot serialize the unknown event type!")
    }
}
