// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transcribestreaming.transform

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.eventstream.MessageType
import aws.sdk.kotlin.runtime.protocol.eventstream.decodeFrames
import aws.sdk.kotlin.runtime.protocol.eventstream.type
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transcribestreaming.model.LanguageCode
import aws.sdk.kotlin.services.transcribestreaming.model.MediaEncoding
import aws.sdk.kotlin.services.transcribestreaming.model.MedicalContentIdentificationType
import aws.sdk.kotlin.services.transcribestreaming.model.MedicalTranscriptResultStream
import aws.sdk.kotlin.services.transcribestreaming.model.Specialty
import aws.sdk.kotlin.services.transcribestreaming.model.StartMedicalStreamTranscriptionResponse
import aws.sdk.kotlin.services.transcribestreaming.model.TranscribeStreamingException
import aws.sdk.kotlin.services.transcribestreaming.model.Type
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class StartMedicalStreamTranscriptionOperationDeserializer: HttpDeserialize<StartMedicalStreamTranscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartMedicalStreamTranscriptionResponse {
        if (!response.status.isSuccess()) {
            throwStartMedicalStreamTranscriptionError(context, response)
        }
        val builder = StartMedicalStreamTranscriptionResponse.Builder()

        builder.contentIdentificationType = response.headers["x-amzn-transcribe-content-identification-type"]?.let { MedicalContentIdentificationType.fromValue(it) }
        builder.enableChannelIdentification = response.headers["x-amzn-transcribe-enable-channel-identification"]?.toBoolean() ?: false
        builder.languageCode = response.headers["x-amzn-transcribe-language-code"]?.let { LanguageCode.fromValue(it) }
        builder.mediaEncoding = response.headers["x-amzn-transcribe-media-encoding"]?.let { MediaEncoding.fromValue(it) }
        builder.mediaSampleRateHertz = response.headers["x-amzn-transcribe-sample-rate"]?.toInt()
        builder.numberOfChannels = response.headers["x-amzn-transcribe-number-of-channels"]?.toInt()
        builder.requestId = response.headers["x-amzn-request-id"]
        builder.sessionId = response.headers["x-amzn-transcribe-session-id"]
        builder.showSpeakerLabel = response.headers["x-amzn-transcribe-show-speaker-label"]?.toBoolean() ?: false
        builder.specialty = response.headers["x-amzn-transcribe-specialty"]?.let { Specialty.fromValue(it) }
        builder.type = response.headers["x-amzn-transcribe-type"]?.let { Type.fromValue(it) }
        builder.vocabularyName = response.headers["x-amzn-transcribe-vocabulary-name"]

        deserializeStartMedicalStreamTranscriptionOperationBody(builder, response.body)
        return builder.build()
    }
}

private suspend fun throwStartMedicalStreamTranscriptionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TranscribeStreamingException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TranscribeStreamingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeStartMedicalStreamTranscriptionOperationBody(builder: StartMedicalStreamTranscriptionResponse.Builder, body: HttpBody) {
    val chan = body.toSdkByteReadChannel() ?: return
    val events = decodeFrames(chan)
        .map { message ->
            when(val mt = message.type()) {
                is MessageType.Event -> when(mt.shapeType) {
                    "TranscriptEvent" -> {
                        val e = deserializeMedicalTranscriptEventPayload(message.payload)
                        MedicalTranscriptResultStream.TranscriptEvent(e)
                    }
                    else -> MedicalTranscriptResultStream.SdkUnknown
                }
                is MessageType.Exception -> when(mt.shapeType){
                    "BadRequestException" -> {
                        val err = deserializeBadRequestExceptionPayload(message.payload)
                        throw err
                    }
                    "LimitExceededException" -> {
                        val err = deserializeLimitExceededExceptionPayload(message.payload)
                        throw err
                    }
                    "InternalFailureException" -> {
                        val err = deserializeInternalFailureExceptionPayload(message.payload)
                        throw err
                    }
                    "ConflictException" -> {
                        val err = deserializeConflictExceptionPayload(message.payload)
                        throw err
                    }
                    "ServiceUnavailableException" -> {
                        val err = deserializeServiceUnavailableExceptionPayload(message.payload)
                        throw err
                    }
                    else -> throw TranscribeStreamingException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw TranscribeStreamingException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }
    builder.transcriptResultStream = events
}
